/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api;

import com.benryan.apache.poi.util.HexDump;
import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherRecordFactory;
import com.benryan.escher.api.EscherSerializationListener;

public class EscherSpgrRecord
extends EscherRecord {
    public static final short RECORD_ID = -4087;
    public static final String RECORD_DESCRIPTION = "MsofbtSpgr";
    private int field_1_rectX1;
    private int field_2_rectY1;
    private int field_3_rectX2;
    private int field_4_rectY2;

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        int size = 0;
        this.field_1_rectX1 = LittleEndian.getInt(data, pos + size);
        this.field_2_rectY1 = LittleEndian.getInt(data, pos + (size += 4));
        this.field_3_rectX2 = LittleEndian.getInt(data, pos + (size += 4));
        this.field_4_rectY2 = LittleEndian.getInt(data, pos + (size += 4));
        if ((bytesRemaining -= (size += 4)) != 0) {
            throw new RuntimeException("Expected no remaining bytes but got " + bytesRemaining);
        }
        return 8 + size + bytesRemaining;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = 16;
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        LittleEndian.putInt(data, offset + 8, this.field_1_rectX1);
        LittleEndian.putInt(data, offset + 12, this.field_2_rectY1);
        LittleEndian.putInt(data, offset + 16, this.field_3_rectX2);
        LittleEndian.putInt(data, offset + 20, this.field_4_rectY2);
        listener.afterRecordSerialize(offset + this.getRecordSize(), this.getRecordId(), offset + this.getRecordSize(), this);
        return 24;
    }

    @Override
    public int getRecordSize() {
        return 24;
    }

    @Override
    public short getRecordId() {
        return -4087;
    }

    @Override
    public String getRecordName() {
        return "Spgr";
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex((short)-4087) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  RectX: " + this.field_1_rectX1 + nl + "  RectY: " + this.field_2_rectY1 + nl + "  RectWidth: " + this.field_3_rectX2 + nl + "  RectHeight: " + this.field_4_rectY2 + nl;
    }

    public int getRectX1() {
        return this.field_1_rectX1;
    }

    public void setRectX1(int x1) {
        this.field_1_rectX1 = x1;
    }

    public int getRectY1() {
        return this.field_2_rectY1;
    }

    public void setRectY1(int y1) {
        this.field_2_rectY1 = y1;
    }

    public int getRectX2() {
        return this.field_3_rectX2;
    }

    public void setRectX2(int x2) {
        this.field_3_rectX2 = x2;
    }

    public int getRectY2() {
        return this.field_4_rectY2;
    }

    public void setRectY2(int field_4_rectY2) {
        this.field_4_rectY2 = field_4_rectY2;
    }
}

