/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherArrayProperty;
import com.benryan.escher.api.EscherBoolProperty;
import com.benryan.escher.api.EscherComplexProperty;
import com.benryan.escher.api.EscherProperties;
import com.benryan.escher.api.EscherProperty;
import com.benryan.escher.api.EscherRGBProperty;
import com.benryan.escher.api.EscherShapePathProperty;
import com.benryan.escher.api.EscherSimpleProperty;
import java.util.ArrayList;
import java.util.List;

public class EscherPropertyFactory {
    public List<EscherProperty> createProperties(byte[] data, int offset, short numProperties) {
        ArrayList<EscherProperty> results = new ArrayList<EscherProperty>(numProperties);
        int pos = offset;
        for (int i = 0; i < numProperties; ++i) {
            short propId = LittleEndian.getShort(data, pos);
            int propData = LittleEndian.getInt(data, pos + 2);
            short propNumber = (short)(propId & 0x3FFF);
            boolean isComplex = (propId & Short.MIN_VALUE) != 0;
            byte propertyType = EscherProperties.getPropertyType(propNumber);
            if (propertyType == 1) {
                results.add(new EscherBoolProperty(propId, propData));
            } else if (propertyType == 2) {
                results.add(new EscherRGBProperty(propId, propData));
            } else if (propertyType == 3) {
                results.add(new EscherShapePathProperty(propId, propData));
            } else if (!isComplex) {
                results.add(new EscherSimpleProperty(propId, propData));
            } else if (propertyType == 5) {
                results.add(new EscherArrayProperty(propId, new byte[propData]));
            } else {
                results.add(new EscherComplexProperty(propId, new byte[propData]));
            }
            pos += 6;
        }
        for (EscherProperty p : results) {
            if (!(p instanceof EscherComplexProperty)) continue;
            if (p instanceof EscherArrayProperty) {
                pos += ((EscherArrayProperty)p).setArrayData(data, pos);
                continue;
            }
            byte[] complexData = ((EscherComplexProperty)p).getComplexData();
            System.arraycopy(data, pos, complexData, 0, complexData.length);
            pos += complexData.length;
        }
        return results;
    }
}

