/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api;

import com.benryan.apache.poi.util.HexDump;
import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherProperty;
import com.benryan.escher.api.EscherPropertyFactory;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherRecordFactory;
import com.benryan.escher.api.EscherSerializationListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EscherOptRecord
extends EscherRecord {
    public static final short RECORD_ID = -4085;
    public static final String RECORD_DESCRIPTION = "msofbtOPT";
    private List<EscherProperty> properties = new ArrayList<EscherProperty>();

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory escherPropertyFactory = new EscherPropertyFactory();
        this.properties = escherPropertyFactory.createProperties(data, pos, this.getInstance());
        return bytesRemaining + 8;
    }

    public int size() {
        return this.properties.size();
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        for (EscherProperty escherProperty : this.properties) {
            pos += escherProperty.serializeSimplePart(data, pos);
        }
        for (EscherProperty escherProperty : this.properties) {
            pos += escherProperty.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    @Override
    public short getOptions() {
        this.setOptions((short)(this.properties.size() << 4 | 3));
        return super.getOptions();
    }

    @Override
    public String getRecordName() {
        return "Opt";
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        for (EscherProperty escherProperty : this.properties) {
            totalSize += escherProperty.getPropertySize();
        }
        return totalSize;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder propertiesBuf = new StringBuilder();
        for (EscherProperty property : this.properties) {
            propertiesBuf.append("    ").append(property.toString()).append(nl);
        }
        return "org.apache.poi.ddf.EscherOptRecord:" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this.getChildRecords().size() + nl + "  properties:" + nl + propertiesBuf.toString();
    }

    public List getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return this.properties.get(index);
    }

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator<EscherProperty>(){

            @Override
            public int compare(EscherProperty p1, EscherProperty p2) {
                return new Short(p1.getPropertyNumber()).compareTo(p2.getPropertyNumber());
            }
        });
    }
}

