/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api;

import com.benryan.apache.poi.util.HexDump;
import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherRecordFactory;
import com.benryan.escher.api.EscherSerializationListener;
import com.benryan.escher.api.EscherSpRecord;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class EscherContainerRecord
extends EscherRecord {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private List<EscherRecord> childRecords = new ArrayList<EscherRecord>();

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int bytesWritten = 8;
        offset += 8;
        while (bytesRemaining > 0 && offset < data.length) {
            EscherRecord child = recordFactory.createRecord(data, offset);
            int childBytesWritten = child.fillFields(data, offset, recordFactory);
            bytesWritten += childBytesWritten;
            offset += childBytesWritten;
            bytesRemaining -= childBytesWritten;
            this.getChildRecords().add(child);
        }
        return bytesWritten;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = 0;
        for (EscherRecord r : this.getChildRecords()) {
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        int pos = offset + 8;
        for (EscherRecord r : this.getChildRecords()) {
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    @Override
    public int getRecordSize() {
        int childRecordsSize = 0;
        for (EscherRecord r : this.getChildRecords()) {
            childRecordsSize += r.getRecordSize();
        }
        return 8 + childRecordsSize;
    }

    @Override
    public List<EscherRecord> getChildRecords() {
        return this.childRecords;
    }

    @Override
    public void setChildRecords(List<EscherRecord> childRecords) {
        this.childRecords = childRecords;
    }

    @Override
    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    @Override
    public void display(PrintWriter w, int indent) {
        super.display(w, indent);
        for (EscherRecord escherRecord : this.childRecords) {
            escherRecord.display(w, indent + 1);
        }
    }

    public void addChildRecord(EscherRecord record) {
        this.childRecords.add(record);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder children = new StringBuilder();
        if (this.getChildRecords().size() > 0) {
            children.append("  children: ").append(nl);
            for (EscherRecord record : this.getChildRecords()) {
                children.append(record.toString());
            }
        }
        return this.getClass().getName() + " (" + this.getRecordName() + "):" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this.getChildRecords().size() + nl + children.toString();
    }

    public EscherSpRecord getChildById(short recordId) {
        for (EscherRecord escherRecord : this.childRecords) {
            if (escherRecord.getRecordId() != recordId) continue;
            return (EscherSpRecord)escherRecord;
        }
        return null;
    }
}

