/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api;

import com.benryan.apache.poi.util.HexDump;
import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherProperties;
import com.benryan.escher.api.EscherProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EscherComplexProperty
extends EscherProperty {
    byte[] complexData = new byte[0];

    public EscherComplexProperty(short id, byte[] complexData) {
        super(id);
        this.complexData = complexData;
    }

    public EscherComplexProperty(short propertyNumber, boolean isBlipId, byte[] complexData) {
        super(propertyNumber, true, isBlipId);
        this.complexData = complexData;
    }

    @Override
    public int serializeSimplePart(byte[] data, int pos) {
        LittleEndian.putShort(data, pos, this.getId());
        LittleEndian.putInt(data, pos + 2, this.complexData.length);
        return 6;
    }

    @Override
    public int serializeComplexPart(byte[] data, int pos) {
        System.arraycopy(this.complexData, 0, data, pos, this.complexData.length);
        return this.complexData.length;
    }

    public byte[] getComplexData() {
        return this.complexData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EscherComplexProperty)) {
            return false;
        }
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)o;
        return Arrays.equals(this.complexData, escherComplexProperty.complexData);
    }

    @Override
    public int getPropertySize() {
        return 6 + this.complexData.length;
    }

    public int hashCode() {
        return this.getId() * 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String dataStr;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.complexData, 0L, b, 0);
            dataStr = b.toString();
        }
        catch (Exception e) {
            dataStr = e.toString();
        }
        finally {
            try {
                b.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + System.getProperty("line.separator") + dataStr;
    }
}

