/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api;

import com.benryan.escher.api.EscherBSERecord;
import com.benryan.escher.api.EscherBitmapBlip;
import com.benryan.escher.api.EscherBlipRecord;
import com.benryan.escher.api.EscherChildAnchorRecord;
import com.benryan.escher.api.EscherClientAnchorRecord;
import com.benryan.escher.api.EscherClientDataRecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherDgRecord;
import com.benryan.escher.api.EscherDggRecord;
import com.benryan.escher.api.EscherMetafileBlip;
import com.benryan.escher.api.EscherOptRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherRecordFactory;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.EscherSpgrRecord;
import com.benryan.escher.api.EscherSplitMenuColorsRecord;
import com.benryan.escher.api.EscherTextboxRecord;
import com.benryan.escher.api.UnknownEscherRecord;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord.EscherRecordHeader header = EscherRecord.EscherRecordHeader.readHeader(data, offset);
        if ((header.getOptions() & 0xF) == 15 && header.getRecordId() != -4083) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        if (header.getRecordId() >= -4072 && header.getRecordId() <= -3817) {
            EscherBlipRecord r = header.getRecordId() == -4065 || header.getRecordId() == -4067 || header.getRecordId() == -4066 ? new EscherBitmapBlip() : (header.getRecordId() == -4070 || header.getRecordId() == -4069 || header.getRecordId() == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        Constructor recordConstructor = (Constructor)recordsMap.get(new Short(header.getRecordId()));
        EscherRecord escherRecord = null;
        if (recordConstructor != null) {
            try {
                escherRecord = (EscherRecord)recordConstructor.newInstance(new Object[0]);
                escherRecord.setRecordId(header.getRecordId());
                escherRecord.setOptions(header.getOptions());
            }
            catch (Exception e) {
                escherRecord = null;
            }
        }
        return escherRecord == null ? new UnknownEscherRecord() : escherRecord;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        for (int i = 0; i < records.length; ++i) {
            Constructor constructor;
            Class record = null;
            short sid = 0;
            record = records[i];
            try {
                sid = record.getField("RECORD_ID").getShort(null);
                constructor = record.getConstructor(new Class[0]);
            }
            catch (Exception illegalArgumentException) {
                throw new RuntimeException("Unable to determine record types");
            }
            result.put(new Short(sid), constructor);
        }
        return result;
    }
}

