/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher;

import com.benryan.escher.CustomShapeRenderer;
import com.benryan.ppt.api.IAutoShape;
import com.benryan.pptx.record.XMLAutoShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTAdjPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DArcTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DClose;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DLineTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DQuadBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathFillMode;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class XmlCustomShapeRenderer
implements CustomShapeRenderer {
    @Override
    public void renderCustomShape(Graphics2D g, IAutoShape ishape, Rectangle2D rec) {
        CTPath2D[] pathArray;
        double lineWidth = ishape.getLineWidth();
        Paint fill = ishape.getFillColor();
        Color line = ishape.getLineColor();
        XMLAutoShape shape = (XMLAutoShape)ishape;
        CTShape ctShape = shape.getCTShape();
        CTShapeProperties shapeProps = ctShape.getSpPr();
        CTCustomGeometry2D custGeom = shapeProps.getCustGeom();
        if (custGeom == null) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke((float)lineWidth));
        for (CTPath2D path : pathArray = custGeom.getPathLst().getPathArray()) {
            XmlObject[] children;
            boolean doStroke = path.getStroke();
            STPathFillMode.Enum fillEnum = path.getFill();
            boolean doFill = fillEnum == null || fillEnum.intValue() != 1;
            long w = path.getW();
            long h = path.getH();
            AffineTransform transform = new AffineTransform();
            if (w > 0L && h > 0L) {
                transform = shape.createAutoShapeTransform(new Rectangle((int)w, (int)h), rec, transform);
            }
            GeneralPath gp = new GeneralPath();
            for (XmlObject xmlObject : children = path.selectChildren(QNameSet.ALL)) {
                if (xmlObject instanceof CTPath2DMoveTo) {
                    CTPath2DMoveTo moveTo = (CTPath2DMoveTo)xmlObject;
                    CTAdjPoint2D pt = moveTo.getPt();
                    double[] values = this.convertPoint(pt);
                    gp.moveTo((float)values[0], (float)values[1]);
                }
                if (xmlObject instanceof CTPath2DLineTo) {
                    CTPath2DLineTo lineTo = (CTPath2DLineTo)xmlObject;
                    double[] values = this.convertPoint(lineTo.getPt());
                    gp.lineTo((float)values[0], (float)values[1]);
                }
                if (xmlObject instanceof CTPath2DArcTo) {
                    CTPath2DArcTo arcTo = (CTPath2DArcTo)xmlObject;
                    double widthRadius = this.getDouble(arcTo.getWR());
                    double heightRadius = this.getDouble(arcTo.getHR());
                    double startAngle = 360.0 - this.getDouble(arcTo.getStAng()) / 60000.0;
                    double swingAngle = this.getDouble(arcTo.getSwAng()) / -60000.0;
                    Rectangle2D.Double arcRec = new Rectangle2D.Double(0.0, 0.0, 2.0 * widthRadius, 2.0 * heightRadius);
                    Arc2D.Double myArc = new Arc2D.Double(arcRec, startAngle, swingAngle, 0);
                    Point2D currentPathPoint = gp.getCurrentPoint();
                    Point2D arcStartPoint = myArc.getStartPoint();
                    AffineTransform arcTranslate = AffineTransform.getTranslateInstance(currentPathPoint.getX() - arcStartPoint.getX(), currentPathPoint.getY() - arcStartPoint.getY());
                    Shape translatedArc = arcTranslate.createTransformedShape(myArc);
                    gp.append(translatedArc, true);
                }
                if (xmlObject instanceof CTPath2DCubicBezierTo) {
                    CTPath2DCubicBezierTo cubicBez = (CTPath2DCubicBezierTo)xmlObject;
                    CTAdjPoint2D[] ptArray = cubicBez.getPtArray();
                    double[] coords = this.getCoords(ptArray);
                    gp.curveTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                }
                if (xmlObject instanceof CTPath2DQuadBezierTo) {
                    CTPath2DQuadBezierTo quadBez = (CTPath2DQuadBezierTo)xmlObject;
                    double[] coords = this.getCoords(quadBez.getPtArray());
                    gp.quadTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3]);
                }
                if (!(xmlObject instanceof CTPath2DClose)) continue;
                gp.closePath();
            }
            Shape finalShape = transform.createTransformedShape(gp);
            if (doFill && fill != null) {
                g.setPaint(fill);
                g.fill(finalShape);
            }
            g.setPaint(line);
            if (!doStroke) continue;
            g.draw(finalShape);
        }
        g.setStroke(oldStroke);
    }

    private double[] getCoords(CTAdjPoint2D[] ptArray) {
        double[] coords = new double[ptArray.length * 2];
        for (int i = 0; i < ptArray.length; ++i) {
            double[] ptCoords = this.convertPoint(ptArray[i]);
            coords[i * 2] = ptCoords[0];
            coords[i * 2 + 1] = ptCoords[1];
        }
        return coords;
    }

    private double[] convertPoint(CTAdjPoint2D pt) {
        return new double[]{this.getDouble(pt.getX()), this.getDouble(pt.getY())};
    }

    private double getDouble(Object obj) {
        return Double.parseDouble(obj.toString());
    }
}

