/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher;

import com.benryan.escher.api.usermodel.IShapeGroup;
import com.benryan.escher.api.usermodel.ITextBox;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.escher.api.usermodel.TextBox;
import com.benryan.graphics.emf.EMFTranscoder;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.ppt.ParagraphLayout;
import com.benryan.ppt.api.IAutoShape;
import com.benryan.ppt.api.ILine;
import com.benryan.ppt.api.IPicture;
import com.benryan.ppt.api.IPictureData;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.model.EscherHostTextContainer;
import com.benryan.ppt.api.usermodel.IParagraph;
import com.benryan.ppt.api.usermodel.IParagraphStyle;
import com.benryan.ppt.api.usermodel.Paragraph;
import com.benryan.ppt.api.util.ImageOptionsFilter;
import com.benryan.ppt.autoshapes.Autoshape;
import com.twelvemonkeys.imageio.plugins.pict.PICTImageReaderSpi;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscherRenderer {
    private static final Logger logger = LoggerFactory.getLogger(EscherRenderer.class);
    public static PICTImageReaderSpi PICT_SPI;

    public void renderImage(Graphics2D g, Rectangle2D rec, IPicture shape, AffineTransform vectorImgTransform, boolean isTexture) {
        IPictureData pd = shape.getPictureData();
        if (pd == null) {
            if (shape.isBackgroundShape()) {
                Paint c = shape.getFillColor();
                g.setPaint(c);
                g.fill(rec);
            }
            return;
        }
        BufferedImage img = null;
        boolean isVectorImg = true;
        switch (pd.getType()) {
            case 4: {
                try {
                    ImageReader reader = PICT_SPI.createReaderInstance();
                    ImageInputStream input = ImageIO.createImageInputStream(new ByteArrayInputStream(pd.getData()));
                    reader.setInput(input);
                    img = reader.read(0);
                }
                catch (Throwable reader) {}
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10001: {
                isVectorImg = false;
                try {
                    img = ImageIO.read(new ByteArrayInputStream(pd.getData()));
                }
                catch (Exception e) {
                    logger.error("Failed to render image", (Throwable)e);
                }
                break;
            }
            case 3: {
                try {
                    double width = rec.getWidth();
                    double height = rec.getHeight();
                    if (vectorImgTransform != null) {
                        width = rec.getWidth() * vectorImgTransform.getScaleX();
                        height = rec.getHeight() * vectorImgTransform.getScaleY();
                    }
                    WmfFile wmf = new WmfFile((InputStream)new ByteArrayInputStream(pd.getData()), (int)width, (int)height);
                    img = wmf.replay(true);
                }
                catch (Exception width) {}
                break;
            }
            case 2: {
                try {
                    double width = rec.getWidth();
                    double height = rec.getHeight();
                    if (vectorImgTransform != null) {
                        width = rec.getWidth() * vectorImgTransform.getScaleX();
                        height = rec.getHeight() * vectorImgTransform.getScaleY();
                    }
                    EMFTranscoder transcoder = new EMFTranscoder();
                    img = transcoder.transcode(new ByteArrayInputStream(pd.getData()), (int)width, (int)height);
                    break;
                }
                catch (Exception width) {
                    // empty catch block
                }
            }
        }
        if (img != null) {
            ImageOptionsFilter filter = new ImageOptionsFilter(shape.getImageOptions());
            img = filter.filter(img);
            AffineTransform oldt = g.getTransform();
            if (!isTexture) {
                g.setTransform(shape.createAutoShapeTransform(new Rectangle(img.getWidth(), img.getHeight()), rec, oldt));
            }
            g.drawImage((Image)img, 0, 0, null);
            g.setTransform(oldt);
        }
    }

    public void walkShapes(Graphics2D g, IShape[] shapes, AffineTransform anchorTransform, AffineTransform vectorImgTransform, boolean isMaster) {
        for (int x = 0; x < shapes.length; ++x) {
            IShape shape;
            Rectangle2D rec = shapes[x].getAnchor();
            if (anchorTransform != null) {
                Point2D.Double upperLeft = new Point2D.Double(rec.getX(), rec.getY());
                Point2D.Double lowerRight = new Point2D.Double(rec.getX() + rec.getWidth(), rec.getY() + rec.getHeight());
                Point newUpperLeft = new Point();
                Point newLowerRight = new Point();
                anchorTransform.transform(upperLeft, newUpperLeft);
                anchorTransform.transform(lowerRight, newLowerRight);
                rec = new Rectangle(newUpperLeft.x, newUpperLeft.y, newLowerRight.x - newUpperLeft.x, newLowerRight.y - newUpperLeft.y);
            }
            if (shapes[x] instanceof ILine) {
                ILine line = (ILine)shapes[x];
                this.renderLine(g, line, rec);
                continue;
            }
            if (shapes[x] instanceof IAutoShape) {
                shape = (IAutoShape)shapes[x];
                this.renderAutoshape(g, isMaster, (IAutoShape)shape, rec);
                continue;
            }
            if (shapes[x] instanceof TextBox) {
                shape = (TextBox)shapes[x];
                EscherHostTextContainer run = ((Shape)shape).getHostObject().getTextContainer((Shape)shape);
                this.renderTextBox(g, isMaster, (TextBox)shape, run, rec);
                continue;
            }
            if (shapes[x] instanceof IPicture) {
                shape = (IPicture)shapes[x];
                this.renderImage(g, rec, (IPicture)shape, vectorImgTransform, false);
                continue;
            }
            if (!(shapes[x] instanceof IShapeGroup)) continue;
            shape = (IShapeGroup)shapes[x];
            AffineTransform newTransform = shape.getChildTransform(anchorTransform);
            this.walkShapes(g, shape.getShapes(), newTransform, vectorImgTransform, isMaster);
        }
    }

    private void drawText(Graphics2D g, boolean isMaster, ITextBox shape, EscherHostTextContainer run, Rectangle2D anchor) {
        AffineTransform oldTransform = g.getTransform();
        AffineTransform transform = shape.createAutoShapeTransform(anchor, anchor, oldTransform);
        transform.translate(anchor.getX(), anchor.getY());
        if (run != null && shape.shouldRender(isMaster)) {
            List<Paragraph> paragraphs = run.getParagraphs();
            ParagraphLayout[] layouts = new ParagraphLayout[paragraphs.size()];
            double layoutHeight = 0.0;
            boolean softBreak = false;
            for (int z = 0; z < paragraphs.size(); ++z) {
                IParagraph paragraph = paragraphs.get(z);
                IParagraphStyle paragraphStyle = paragraph.getStyle();
                layouts[z] = new ParagraphLayout(paragraphStyle);
                layouts[z].layoutParagraph(g, shape, anchor, paragraph);
                if (z != 0 && !softBreak) {
                    layoutHeight += layouts[z].getSpaceBefore();
                }
                softBreak = layouts[z].isSoftBreak();
                layoutHeight += layouts[z].getParagraphHeight();
                if (z == paragraphs.size() - 1 || softBreak) continue;
                layoutHeight += layouts[z].getSpaceAfter();
            }
            double yStart = shape.getMarginTop();
            int vertAlign = shape.getVerticalAlignment();
            vertAlign = vertAlign == -1 ? run.getDefaultVertAlign() : vertAlign;
            switch (vertAlign) {
                case 2: 
                case 5: 
                case 7: 
                case 9: {
                    yStart = anchor.getHeight() - ((double)shape.getMarginBottom() + layoutHeight);
                    break;
                }
                case 1: 
                case 4: {
                    yStart = (anchor.getHeight() - (layoutHeight + (double)shape.getMarginBottom() + (double)shape.getMarginTop())) / 2.0;
                }
            }
            g.setTransform(transform);
            softBreak = false;
            for (int z = 0; z < layouts.length; ++z) {
                if (z != 0 && !softBreak) {
                    yStart += layouts[z].getSpaceBefore();
                }
                boolean noBullet = z != 0 && layouts[z - 1].isSoftBreak();
                ArrayList textLayouts = layouts[z].getLayouts();
                for (int c = 0; c < textLayouts.size(); ++c) {
                    TextLayout bulletLayout = null;
                    if (c == 0 && !noBullet) {
                        bulletLayout = layouts[z].getBulletLayout();
                    }
                    TextLayout nextLayout = (TextLayout)textLayouts.get(c);
                    double textWidth = nextLayout.getAdvance();
                    double textHeight = nextLayout.getAscent() + nextLayout.getDescent();
                    double lineSpacing = layouts[z].getLineHeight(c);
                    double xStart = this.getXStart(layouts[z], shape, anchor, textWidth, bulletLayout != null ? bulletLayout.getAdvance() : 0.0f, c == 0);
                    yStart += lineSpacing - textHeight;
                    yStart += (double)nextLayout.getAscent();
                    if (bulletLayout != null) {
                        double bulletYStart = yStart;
                        double bulletXStart = shape.getMarginLeft() + layouts[z].getBulletIndent();
                        g.setColor(layouts[z].getBulletColor());
                        bulletLayout.draw(g, (float)bulletXStart, (float)bulletYStart);
                        if (layouts[z].getBulletIndent() == layouts[z].getFirstLineIndent()) {
                            xStart += (double)bulletLayout.getAdvance();
                        }
                    }
                    g.setColor(layouts[z].getTextColor());
                    nextLayout.draw(g, (float)xStart, (float)yStart);
                    yStart += (double)nextLayout.getDescent();
                }
                softBreak = layouts[z].isSoftBreak();
                if (z == layouts.length - 1 || softBreak) continue;
                yStart += layouts[z].getSpaceAfter();
            }
            g.setTransform(oldTransform);
        }
    }

    private double getXStart(ParagraphLayout layout, ITextBox shape, Rectangle2D anchor, double layoutWidth, double bulletWidth, boolean firstLine) {
        int alignment = layout.getParagraphAlignment();
        double lineIndent = 0.0;
        if (bulletWidth > 0.0) {
            if (layout.getBulletIndent() == layout.getFirstLineIndent()) {
                layoutWidth += bulletWidth;
            }
            lineIndent = layout.getFirstLineIndent();
        } else {
            lineIndent = firstLine ? (double)layout.getFirstLineIndent() : (double)layout.getIndent();
        }
        switch (alignment) {
            case 1: {
                return ((double)shape.getMarginLeft() + lineIndent + anchor.getWidth() - ((double)shape.getMarginRight() + layoutWidth)) / 2.0;
            }
            case 2: {
                return anchor.getWidth() - ((double)shape.getMarginRight() + layoutWidth);
            }
        }
        return (double)shape.getMarginLeft() + lineIndent;
    }

    private void renderAutoshape(Graphics2D g, boolean isMaster, IAutoShape shape, Rectangle2D rec) {
        ITextBox txbx;
        EscherHostTextContainer run;
        boolean isUserDefined = shape.isUserDefined();
        if (rec.getHeight() == 0.0 || rec.getWidth() == 0.0) {
            this.renderLine(g, shape, rec);
            return;
        }
        if (isUserDefined) {
            shape.getCustomShapeRenderer().renderCustomShape(g, shape, rec);
        } else {
            Autoshape shapeRender;
            double lineWidth = shape.getLineWidth();
            Paint fill = shape.getFillColor();
            Color line = shape.getLineColor();
            if (fill == null) {
                fill = new Color(0, 0, 0, 0);
            }
            if ((shapeRender = shape.getPredefinedShape(rec)) != null) {
                shapeRender.setDimensions(rec.getWidth(), rec.getHeight());
                AffineTransform oldt = new AffineTransform();
                Rectangle logicalRec = new Rectangle(shapeRender.getOrigin().x, shapeRender.getOrigin().y, (int)shapeRender.getWidth(), (int)shapeRender.getHeight());
                AffineTransform newt = shape.createAutoShapeTransform(logicalRec, rec, oldt);
                Stroke oldStroke = g.getStroke();
                if (lineWidth != 0.0) {
                    g.setStroke(new BasicStroke((float)(lineWidth / Math.abs(oldt.getScaleX()))));
                }
                shapeRender.createShape(g, fill, line, newt);
                g.setStroke(oldStroke);
            }
        }
        if (!isMaster && shape.doesShapeHaveText() && (run = (txbx = shape.getTextBox()).getEscherHostTextContainer()) != null) {
            Rectangle2D anchor = rec;
            Rectangle2D customAnchor = txbx.getTextRectangle(rec);
            if (customAnchor != null) {
                anchor = customAnchor;
            }
            this.drawText(g, isMaster, txbx, run, anchor);
        }
    }

    private void renderLine(Graphics2D g, IAutoShape shape, Rectangle2D anchor) {
        g.setColor(shape.getLineColor());
        g.setStroke(new BasicStroke((float)shape.getLineWidth()));
        AffineTransform oldt = g.getTransform();
        AffineTransform newt = shape.createAutoShapeTransform(anchor, anchor, oldt);
        Point2D.Double start = new Point2D.Double(anchor.getX(), anchor.getY());
        Point2D.Double end = new Point2D.Double(anchor.getX() + anchor.getWidth(), anchor.getY() + anchor.getHeight());
        Line2D.Double gLine = new Line2D.Double(start, end);
        g.setTransform(newt);
        g.draw(gLine);
        g.setTransform(oldt);
    }

    private void renderTextBox(Graphics2D g, boolean isMaster, TextBox shape, EscherHostTextContainer run, Rectangle2D anchor) {
        Color fill = shape.getFillColor();
        Color draw = shape.getLineColor();
        if (fill != null) {
            g.setPaint(fill);
            g.fill(anchor);
        }
        if (draw != null) {
            g.setStroke(new BasicStroke((float)shape.getLineWidth()));
            g.setPaint(draw);
            g.draw(anchor);
        }
        this.drawText(g, isMaster, shape, run, anchor);
    }

    static {
        try {
            PICT_SPI = new PICTImageReaderSpi();
            PICTImageReaderSpi obj = IIORegistry.getDefaultInstance().getServiceProviderByClass(PICTImageReaderSpi.class);
            if (obj != null) {
                IIORegistry.getDefaultInstance().deregisterServiceProvider(obj);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

