/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher;

import com.benryan.escher.CustomShapeRenderer;
import com.benryan.escher.api.usermodel.AutoShape;
import com.benryan.escher.api.usermodel.PathInfo;
import com.benryan.ppt.api.IAutoShape;
import com.benryan.ppt.autoshapes.path.PathCreator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class BinaryCustomShapeRenderer
implements CustomShapeRenderer {
    @Override
    public void renderCustomShape(Graphics2D g, IAutoShape ishape, Rectangle2D rec) {
        double lineWidth = ishape.getLineWidth();
        Paint fill = ishape.getFillColor();
        Color line = ishape.getLineColor();
        AutoShape shape = (AutoShape)ishape;
        AffineTransform oldt = new AffineTransform();
        Rectangle logicalRec = new Rectangle((int)shape.getMinX(), (int)shape.getMinY(), (int)(shape.getMaxX() - shape.getMinX()), (int)(shape.getMaxY() - shape.getMinY()));
        AffineTransform newt = shape.createAutoShapeTransform(logicalRec, rec, oldt);
        Stroke oldStroke = g.getStroke();
        double scaleX = Math.sqrt(oldt.getScaleX() * oldt.getScaleX() + oldt.getShearX() * oldt.getShearX());
        g.setStroke(new BasicStroke((float)(lineWidth / scaleX)));
        GeneralPath path = new GeneralPath();
        PathCreator pc = new PathCreator();
        boolean nofill = false;
        boolean nostroke = false;
        List<PathInfo> segments = shape.getPathOperations();
        for (PathInfo pathInfo : segments) {
            switch (pathInfo.getOp()) {
                case MOVE_TO: {
                    pc.moveTo(path, pathInfo.getOpPoints());
                    break;
                }
                case LINE_TO: {
                    pc.lineTo(path, pathInfo.getOpPoints());
                    break;
                }
                case CURVE_TO: {
                    pc.curveTo(path, pathInfo.getOpPoints());
                    break;
                }
                case CLOSE: {
                    path.closePath();
                    break;
                }
                case END: {
                    Shape sh = newt.createTransformedShape(path);
                    if (!nofill && fill != null) {
                        g.setPaint(fill);
                        g.fill(sh);
                    }
                    g.setPaint(line);
                    if (!nostroke) {
                        g.draw(sh);
                    }
                    path = new GeneralPath();
                    nofill = false;
                    nostroke = false;
                    break;
                }
                case ANGLE_ELLIPSE_TO: {
                    pc.angleEllipseTo(path, pathInfo.getOpPoints());
                    break;
                }
                case ANGLE_ELLIPSE: {
                    pc.angleEllipse(path, pathInfo.getOpPoints());
                    break;
                }
                case ARC_TO: {
                    pc.arcTo(path, pathInfo.getOpPoints());
                    break;
                }
                case CLOCKWISE_ARC_TO: {
                    pc.clockwiseArcTo(path, pathInfo.getOpPoints());
                    break;
                }
                case CLOCKWISE_ARC: {
                    pc.clockwiseArc(path, pathInfo.getOpPoints());
                    break;
                }
                case ELLIPTICAL_QUAD_X: {
                    pc.ellipticalQuadrantX(path, pathInfo.getOpPoints());
                    break;
                }
                case ELLIPTICAL_QUAD_Y: {
                    pc.ellipticalQuadrantY(path, pathInfo.getOpPoints());
                    break;
                }
                case QUAD_BEZ: {
                    pc.quadraticBezier(path, pathInfo.getOpPoints());
                    break;
                }
                case NO_FILL: {
                    nofill = true;
                    break;
                }
                case NO_STROKE: {
                    nostroke = true;
                }
            }
        }
        g.setStroke(oldStroke);
    }
}

