/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.spi.functions;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.fugue.Option;
import com.atlassian.querylang.functions.EvaluationContext;

public final class CQLEvaluationContext
extends EvaluationContext {
    private final Option<String> spaceKey;
    private final Option<ContentId> contentId;
    private final Option<ContentType> contentType;

    private CQLEvaluationContext(Builder builder) {
        super(builder.username);
        this.spaceKey = Option.option((Object)builder.spaceKey);
        this.contentId = Option.option((Object)builder.contentId);
        this.contentType = Option.option((Object)builder.contentType);
    }

    public Option<String> getCurrentSpaceKey() {
        return this.spaceKey;
    }

    public Option<ContentId> getCurrentContent() {
        return this.contentId;
    }

    public Option<ContentType> getCurrentContentType() {
        return this.contentType;
    }

    public static Builder builder() {
        return new Builder().user(AuthenticatedUserThreadLocal.getUsername());
    }

    public static Builder builder(SearchContext searchContext) {
        return CQLEvaluationContext.builder().content((ContentId)searchContext.getContentId().getOrNull()).spaceKey((String)searchContext.getSpaceKey().getOrNull());
    }

    public static class Builder {
        private String username;
        private String spaceKey;
        private ContentId contentId;
        private ContentType contentType;

        private Builder() {
        }

        public Builder user(String username) {
            this.username = username;
            return this;
        }

        public Builder spaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder content(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        public Builder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public CQLEvaluationContext build() {
            return new CQLEvaluationContext(this);
        }
    }
}

