/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.literals;

import com.atlassian.querylang.exceptions.GenericQueryException;
import com.atlassian.querylang.exceptions.UnterminatedStringQueryException;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;

public class StringLiteralHelper {
    public static String stripQuotes(String possiblyQuotedValue) {
        String trimmed = possiblyQuotedValue.trim();
        char firstChar = trimmed.charAt(0);
        if (firstChar == '\"' || firstChar == '\'') {
            int lastCharIndex = trimmed.length() - 1;
            if (trimmed.charAt(lastCharIndex) != firstChar) {
                throw new UnterminatedStringQueryException("Unmatched quote wrapping phrase query near : " + trimmed);
            }
            if (trimmed.charAt(lastCharIndex - 1) == '\\') {
                throw new UnterminatedStringQueryException("Escaped end quote in phrase query near : " + trimmed);
            }
            trimmed = trimmed.substring(1, lastCharIndex);
        }
        trimmed = trimmed.replace("\\\"", "\"");
        trimmed = StringLiteralHelper.ensureBalancedDoubleQuotes(trimmed);
        trimmed = trimmed.replace("\\'", "'");
        return trimmed;
    }

    public static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new GenericQueryException("Could not parse " + str + " as an integer", e);
        }
    }

    @VisibleForTesting
    static String ensureBalancedDoubleQuotes(String str) {
        if (StringUtils.countMatches((String)str, (String)"\"") % 2 == 0) {
            return str;
        }
        int lastDblQuoteIndex = str.lastIndexOf(34);
        return str.substring(0, lastDblQuoteIndex) + str.substring(lastDblQuoteIndex + 1, str.length());
    }
}

