/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.fields;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.querylang.fields.FieldHandler;
import com.atlassian.querylang.fields.FieldMetaData;
import com.atlassian.querylang.fields.SubfieldHandlerProvider;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;

@ExperimentalSpi
public abstract class BaseFieldHandler
implements FieldHandler,
SubfieldHandlerProvider {
    public final String fieldName;
    private final boolean orderSupported;
    private final FieldMetaData fieldMetaData;

    @Deprecated
    protected BaseFieldHandler(String fieldName, FieldMetaData fieldMetaData) {
        this(fieldName, fieldMetaData, false);
    }

    protected BaseFieldHandler(String fieldName, FieldMetaData fieldMetaData, boolean orderSupported) {
        this.fieldName = fieldName;
        this.fieldMetaData = fieldMetaData;
        this.orderSupported = orderSupported;
    }

    protected BaseFieldHandler(String fieldName) {
        this(fieldName, false);
    }

    protected BaseFieldHandler(String fieldName, boolean orderSupported) {
        this.fieldName = fieldName;
        this.fieldMetaData = FieldMetaData.builder().build();
        this.orderSupported = orderSupported;
    }

    @Override
    public final String fieldName() {
        return this.fieldName;
    }

    @Override
    public final FieldMetaData getFieldMetaData() {
        return this.fieldMetaData;
    }

    @Override
    public final boolean isOrderSupported() {
        return this.orderSupported;
    }

    @Override
    public FieldOrder buildOrder(OrderDirection direction) {
        if (!this.orderSupported) {
            throw new UnsupportedOperationException(this.fieldName + " does not support ordering");
        }
        throw new IllegalStateException(this.getClass().getName() + " supports ordering but does not implement buildOrder for " + this.fieldName);
    }

    protected <T extends Enum> void validateSupportedOp(T operator, Set<T> supportedOperators) {
        if (!supportedOperators.contains(operator)) {
            throw new IllegalArgumentException("Unsupported operation : " + operator);
        }
    }

    @Override
    public Iterable<FieldHandler> getSubfieldHandlers() {
        return Collections.emptyList();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("Field", (Object)this.fieldName).add("Order supported", this.orderSupported).toString();
    }
}

