/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.exceptions;

import com.atlassian.querylang.exceptions.QueryException;
import com.atlassian.querylang.literals.DateLiteralHelper;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;

public class MissingValueQueryException
extends QueryException {
    public MissingValueQueryException(String msg) {
        super(msg);
    }

    public static MissingValueQueryException missingValueForOperator(String operator, String field, String actual) {
        String actualMsg = Strings.isNullOrEmpty((String)actual) ? "" : String.format(" but got '%s'", actual);
        throw new MissingValueQueryException(String.format("Expecting a value for operator '%s' after field '%s'%s", operator, field, actualMsg));
    }

    public static MissingValueQueryException missingValueForDateTimeField(String field, String suppliedValue) {
        throw new MissingValueQueryException(String.format("Date value '%s' for field '%s' is invalid.  Valid formats include: %s", StringUtils.join(DateLiteralHelper.getSupportedDateFormats(), (String)","), suppliedValue, field));
    }
}

