/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.plugins;

import com.atlassian.querylang.fields.UISupport;
import com.atlassian.querylang.fields.ValueType;
import com.atlassian.querylang.fields.ValueTypeFactory;
import com.google.common.base.Strings;
import org.dom4j.Element;

public class UISupportFactory {
    public static UISupport extractUISupport(Element element, ValueTypeFactory valueTypeFactory) {
        UISupport.Builder builder = UISupportFactory.extractUISupportBuilder(element, valueTypeFactory);
        return builder == null ? null : builder.build();
    }

    public static UISupport.Builder extractUISupportBuilder(Element element, ValueTypeFactory valueTypeFactory) {
        if (element == null) {
            return null;
        }
        ValueType vt = null;
        String valueTypeString = element.attributeValue("value-type");
        if (!Strings.isNullOrEmpty((String)valueTypeString)) {
            vt = valueTypeFactory.getValueType(valueTypeString);
        }
        return UISupport.builder().valueType(vt).defaultOperator(element.attributeValue("default-operator")).dataUri(element.attributeValue("data-uri")).i18nKey(element.attributeValue("i18n-key")).tooltipI18nKey(element.attributeValue("i18n-field-tooltip"));
    }
}

