/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.security.MessageDigest;
import tdm.lib.XMLNode;

public class XMLTextNode
extends XMLNode {
    private String text;
    private byte[] cHash = null;
    private boolean cdata;

    public XMLTextNode(String srctext, boolean cdata) {
        super(null);
        this.cdata = cdata;
        this.text = srctext;
        this.cHash = this.calculateHash(this.text);
        this.infoSize = this.text.length() > 5 ? this.text.length() - 5 : 1;
    }

    public XMLTextNode(String text) {
        this(text, false);
    }

    public XMLTextNode(char[] srctext) {
        this(srctext, 0, srctext.length);
    }

    public XMLTextNode(char[] srctext, int first, int length) {
        this(new String(srctext, first, length), false);
    }

    @Override
    public boolean contentEquals(Object a) {
        if (a instanceof XMLTextNode) {
            return MessageDigest.isEqual(this.cHash, ((XMLTextNode)a).cHash);
        }
        return false;
    }

    public char[] getText() {
        return this.text.toCharArray();
    }

    public String getTextAsString() {
        return this.text;
    }

    public void setText(String aText) {
        this.text = aText;
    }

    public boolean isCdata() {
        return this.cdata;
    }

    public String toString() {
        return new String(this.text);
    }

    @Override
    public int getContentHash() {
        return this.cHash[0] + (this.cHash[1] << 8) + (this.cHash[2] << 16) + (this.cHash[3] << 24);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

