/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.HeuristicMatching;
import tdm.lib.Matching;

public class TriMatching {
    private BranchNode leftRoot = null;
    private BranchNode rightRoot = null;
    private BaseNode baseRoot = null;

    public TriMatching(BranchNode left, BaseNode base, BranchNode right) {
        this(left, base, right, HeuristicMatching.class, HeuristicMatching.class);
    }

    public TriMatching(BranchNode left, BaseNode base, BranchNode right, Class leftMatchType, Class rightMatchType) {
        Matching m = null;
        try {
            m = (Matching)rightMatchType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal Error instantiating matching class " + rightMatchType.getName());
        }
        m.buildMatching(base, right);
        this.leftRoot = left;
        this.rightRoot = right;
        this.baseRoot = base;
        this.swapLeftRight(base);
        try {
            m = (Matching)leftMatchType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal Error instantiating matching class " + leftMatchType.getName());
        }
        m.buildMatching(base, left);
        this.setPartners(left, false);
        this.setPartners(right, true);
    }

    protected void swapLeftRight(BaseNode base) {
        base.swapLeftRightMatchings();
        for (int i = 0; i < base.getChildCount(); ++i) {
            this.swapLeftRight(base.getChild(i));
        }
    }

    protected void setPartners(BranchNode n, boolean partnerInLeft) {
        BaseNode baseMatch = n.getBaseMatch();
        if (baseMatch != null) {
            if (partnerInLeft) {
                n.setPartners(baseMatch.getLeft());
            } else {
                n.setPartners(baseMatch.getRight());
            }
        } else {
            n.setPartners(null);
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            this.setPartners(n.getChild(i), partnerInLeft);
        }
    }

    public BranchNode getLeftRoot() {
        return this.leftRoot;
    }

    public BranchNode getRightRoot() {
        return this.rightRoot;
    }

    public BaseNode getBaseRoot() {
        return this.baseRoot;
    }
}

