/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import tdm.lib.Node;

public class PathTracker {
    static final char PATHSEP = '/';
    private LinkedList path = null;
    private int childPos = -1;

    public PathTracker() {
        this.resetContext();
    }

    public void resetContext() {
        this.path = new LinkedList();
        this.childPos = 0;
    }

    public void nextChild() {
        ++this.childPos;
    }

    public void enterSubtree() {
        this.path.addLast(new Integer(this.childPos));
        this.childPos = 0;
    }

    public void exitSubtree() {
        Integer oldpos = (Integer)this.path.removeLast();
        this.childPos = oldpos;
    }

    public String getPathString() {
        return PathTracker.getPathString(this.path, -1, false);
    }

    public String getFullPathString() {
        return PathTracker.getPathString(this.path, this.childPos, true);
    }

    public String getPathString(int achildPos) {
        return PathTracker.getPathString(this.path, achildPos, true);
    }

    public static String getPathString(Node n) {
        return PathTracker.getPathString(PathTracker.makePath(n), -1, false);
    }

    public static String getPathString(Node n, int achildPos) {
        return PathTracker.getPathString(PathTracker.makePath(n), achildPos, true);
    }

    private static String getPathString(LinkedList path, int childPos, boolean useChildPos) {
        StringBuffer p = new StringBuffer();
        Iterator i = path.iterator();
        i.next();
        while (i.hasNext()) {
            p.append('/');
            p.append(((Integer)i.next()).toString());
        }
        if (useChildPos) {
            p.append('/');
            p.append(childPos);
        }
        return p.toString();
    }

    private static LinkedList makePath(Node n) {
        LinkedList<Integer> path = new LinkedList<Integer>();
        do {
            path.addLast(new Integer(n.getChildPos()));
        } while ((n = n.getParentAsNode()) != null);
        Collections.reverse(path);
        return path;
    }

    public static Node followPath(Node root, String path) {
        int pos = 1;
        if (path.length() < 1) {
            return root;
        }
        while (pos < path.length()) {
            int childno = 0;
            while (pos < path.length() && Character.isDigit(path.charAt(pos))) {
                childno = childno * 10 + (path.charAt(pos) - 48);
                ++pos;
            }
            ++pos;
            root = root.getChildAsNode(childno);
        }
        return root;
    }
}

