/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.Vector;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.HeuristicMatching;
import tdm.lib.Node;

public class DiffMatching
extends HeuristicMatching {
    public DiffMatching() {
    }

    public DiffMatching(BaseNode abase, BranchNode abranch) {
        this.buildMatching(abase, abranch);
    }

    @Override
    public void buildMatching(BaseNode base, BranchNode branch) {
        this.baseRoot = base;
        this.branchRoot = branch;
        this.matchSubtrees(base, branch);
    }

    @Override
    protected boolean dfsTryFuzzyMatch(Node a, Node b) {
        return false;
    }

    @Override
    protected Vector findCandidates(BaseNode tree, BranchNode key) {
        Vector candidates = new Vector();
        this.findExactMatches(tree, key, candidates);
        return candidates;
    }

    protected HeuristicMatching.CandidateEntry getBestCandidate(BranchNode branch, Vector bestCandidates) {
        if (bestCandidates.size() > 1) {
            for (HeuristicMatching.CandidateEntry ce : bestCandidates) {
                BranchNode left = (BranchNode)branch.getLeftSibling();
                BaseNode cand = ce.candidate;
                if (left == null || !left.hasBaseMatch() || left.getBaseMatch() != cand.getLeftSibling()) continue;
                return ce;
            }
        }
        if (bestCandidates.isEmpty()) {
            return null;
        }
        return (HeuristicMatching.CandidateEntry)bestCandidates.elementAt(0);
    }

    @Override
    public void getAreaStopNodes(Vector stopNodes, BranchNode n) {
        super.getAreaStopNodes(stopNodes, n);
    }

    @Override
    public BranchNode getBranchRoot() {
        return this.branchRoot;
    }
}

