/*
 * Decompiled with CFR 0.152.
 */
package tdm.editgen;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.xml.sax.helpers.AttributesImpl;
import tdm.editgen.MarkableBaseNode;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.EditLog;
import tdm.lib.MatchedNodes;
import tdm.lib.Node;
import tdm.lib.NodeFactory;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLParser;
import tdm.lib.XMLPrinter;
import tdm.lib.XMLTextNode;

public class Editgen {
    public static final String EDIT_PREFIX = "edits-";
    public static final String ALLOWED_OPS = "diumc";
    private boolean prettyPrint = true;
    private String editLogPrefix = null;
    private double probability = 0.01;
    private int editCount = -1;
    private boolean useEditCount = false;
    private char[] operations = new char[]{'d', 'i', 'u', 'm', 'c'};
    private String idPrefix = "";
    private boolean useIdAttribute = false;
    private boolean updateModifiesId = false;
    private boolean copyModifiesId = false;
    private boolean printStats = true;
    private int delCount = 0;
    private int insCount = 0;
    private int updCount = 0;
    private int moveCount = 0;
    private int copyCount = 0;
    Random rnd = new Random(31415926L);
    static int idCounter = 1000000;
    int _visitCount = 0;
    protected static final int SCAN_UNMARKED = Integer.MIN_VALUE;
    private static NodeFactory baseNodeFactory = new NodeFactory(){

        @Override
        public Node makeNode(XMLNode content) {
            return new MarkableBaseNode(content);
        }
    };
    private static NodeFactory branchNodeFactory = new NodeFactory(){

        @Override
        public Node makeNode(XMLNode content) {
            return new BranchNode(content);
        }
    };

    public static void main(String[] args) {
        Editgen e = new Editgen();
        e.editGen("L7.xml", "m.xml", new String[]{"1.xml", "2.xml"});
    }

    public void editGen(String inFile, String mergeFile, String[] outfiles) {
        MarkableBaseNode docBase = null;
        BranchNode docMerged = null;
        System.err.println("Parsing " + inFile + "...");
        try {
            XMLParser p = new XMLParser();
            docBase = (MarkableBaseNode)p.parse(inFile, baseNodeFactory);
            this.countSubtreeSizes(docBase);
        }
        catch (Exception e) {
            System.err.println("XML Parse error in " + inFile + ". Detailed exception info is:");
            System.err.println(e.toString());
            e.printStackTrace();
            return;
        }
        docMerged = this.clonedAndMatchedTree(docBase, true, true, false, null);
        EditLog mergeLog = new EditLog();
        for (int iFile = 0; iFile < outfiles.length; ++iFile) {
            System.err.println("Making " + outfiles[iFile] + "...");
            EditLog branchLog = new EditLog();
            BranchNode outRoot = this.clonedAndMatchedTree(docBase, false, true, false, null);
            docBase.mark(3);
            ((MarkableBaseNode)docBase.getChild(0)).mark(2);
            int edits = this.editCount == -1 ? (int)((double)docBase.getSubteeSize() * (this.probability / (double)outfiles.length)) : this.editCount;
            this.transform(edits, (MarkableBaseNode)docBase.getChild(0), (MarkableBaseNode)docBase.getChild(0), mergeLog, branchLog);
            try {
                this.printTree(outRoot, new XMLPrinter(new FileOutputStream(outfiles[iFile]), this.prettyPrint));
            }
            catch (IOException x) {
                System.err.println("Unable to write outfile " + outfiles[iFile]);
            }
            if (this.editLogPrefix == null) continue;
            String editLogFile = this.editLogPrefix + outfiles[iFile];
            try {
                branchLog.writeEdits(new XMLPrinter(new FileOutputStream(editLogFile), this.prettyPrint));
                continue;
            }
            catch (Exception x) {
                System.err.println("Unable to write edit log " + editLogFile);
            }
        }
        if (mergeFile != null) {
            try {
                this.printTree(docMerged, new XMLPrinter(new FileOutputStream(mergeFile), this.prettyPrint));
            }
            catch (IOException x) {
                System.err.println("Unable to write outfile " + mergeFile);
            }
        }
        if (this.editLogPrefix != null) {
            String mergeLogFile = this.editLogPrefix + mergeFile;
            try {
                mergeLog.writeEdits(new XMLPrinter(new FileOutputStream(mergeLogFile)));
            }
            catch (Exception x) {
                System.err.println("Unable to write edit log " + mergeLogFile);
            }
        }
        if (this.printStats) {
            System.err.println("Base tree nodes: " + ((MarkableBaseNode)docBase.getChild(0)).getSubteeSize());
            System.err.println("        Inserts: " + this.insCount);
            System.err.println("        Deletes: " + this.delCount);
            System.err.println("        Updates: " + this.updCount);
            System.err.println("          Moves: " + this.moveCount);
            System.err.println("         Copies: " + this.copyCount);
            System.err.println("    Total edits: " + (this.insCount + this.delCount + this.updCount + this.moveCount + this.copyCount));
        }
    }

    public void transform(int edits, MarkableBaseNode base, MarkableBaseNode baseRoot, EditLog mergeLog, EditLog branchLog) {
        int TRIES = 10;
        MarkableBaseNode n = null;
        for (int i = 0; i < edits; ++i) {
            char op = this.operations[(int)(this.rnd.nextDouble() * (double)this.operations.length)];
            int tries = 10;
            do {
                if ((n = this.getRandomNode(baseRoot, op == 'u' ? 1 : 2, null)) != null) continue;
                System.err.println("Ran out of free nodes to edit");
                return;
            } while (!this.editNode(op, n, baseRoot, mergeLog, branchLog) && --tries > 0);
            if (tries != 0) continue;
            System.err.println("Warning: Unable to perform operation " + op);
        }
    }

    public boolean editNode(char op, MarkableBaseNode base, MarkableBaseNode baseRoot, EditLog mergeLog, EditLog branchLog) {
        BranchNode n = null;
        boolean after = false;
        MarkableBaseNode dest = null;
        switch (op) {
            case 'd': {
                dest = this.getLargestDelTree(base);
                if (dest == null) {
                    return false;
                }
                this._checkNotMarked(dest);
                dest.lock(3);
                dest.lockSubtree(3);
                ++this.delCount;
                this.editTrees(dest, null, null, false, false, mergeLog, branchLog);
                break;
            }
            case 'i': {
                ++this.insCount;
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "", "id", "CDATA", "" + this.newId());
                XMLElementNode content = new XMLElementNode("editgen-insert", atts);
                after = this.rnd.nextDouble() > 0.5;
                base.lock(!after, after, 2);
                this.editTrees(null, base, new BranchNode(content), after, false, mergeLog, branchLog);
                break;
            }
            case 'u': {
                this.updateNode(base, mergeLog, branchLog);
                ++this.updCount;
                base.mark(1);
                break;
            }
            case 'm': {
                Node n2;
                base.beginMarkTransaction();
                base.lock(2);
                dest = this.getRandomNode(baseRoot, 2, base);
                if (dest == null || !this._treeHasNoCopyOf(base, dest, true)) {
                    base.abortMarkTransaction();
                    return false;
                }
                after = this.rnd.nextDouble() > 0.5;
                dest.lock(!after, after, 2);
                n = dest.getLeft().getFullMatch();
                Node node = n2 = after ? n.getRightSibling() : n.getLeftSibling();
                if (base.getContent() instanceof XMLTextNode && (n.getContent() instanceof XMLTextNode || n2 != null && n2.getContent() instanceof XMLTextNode)) {
                    base.abortMarkTransaction();
                    return false;
                }
                base.commitMarkTransaction();
                ++this.moveCount;
                this.editTrees(base, dest, null, after, true, mergeLog, branchLog);
                break;
            }
            case 'c': {
                Node n2;
                base.beginMarkTransaction();
                base.lock(2);
                dest = this.getRandomNode(baseRoot, 2, base);
                if (dest == null || !this._treeHasNoCopyOf(base, dest, true)) {
                    base.abortMarkTransaction();
                    return false;
                }
                after = this.rnd.nextDouble() > 0.5;
                dest.lock(!after, after, 2);
                n = dest.getLeft().getFullMatch();
                Node node = n2 = after ? n.getRightSibling() : n.getLeftSibling();
                if (base.getContent() instanceof XMLTextNode && (n.getContent() instanceof XMLTextNode || n2 != null && n2.getContent() instanceof XMLTextNode)) {
                    base.abortMarkTransaction();
                    return false;
                }
                ++this.copyCount;
                base.commitMarkTransaction();
                this.editTrees(null, dest, base, after, true, mergeLog, branchLog);
            }
        }
        return true;
    }

    protected void updateNode(MarkableBaseNode n, EditLog mergeLog, EditLog branchLog) {
        String newId = this.newId();
        this.doUpdateNode(n, mergeLog, true, newId);
        this.doUpdateNode(n, branchLog, false, newId);
    }

    protected void doUpdateNode(MarkableBaseNode b, EditLog log, boolean left, String newId) {
        MatchedNodes m = left ? b.getLeft() : b.getRight();
        for (BranchNode n : m.getMatches()) {
            XMLNode c = n.getContent();
            if (c instanceof XMLTextNode) {
                XMLTextNode ct = (XMLTextNode)c;
                ct.setText(ct.toString() + newId);
            } else {
                XMLElementNode ce = (XMLElementNode)c;
                ce.setQName(ce.getQName() + newId);
                if (this.useIdAttribute && this.updateModifiesId) {
                    int idIx = ce.getAttributes().getIndex("id");
                    ((AttributesImpl)ce.getAttributes()).setValue(idIx, this.newId());
                }
            }
            log.update(n);
        }
    }

    public MarkableBaseNode getRandomNode(MarkableBaseNode root, int markMask, MarkableBaseNode forbiddenTree) {
        int pos = (int)(this.rnd.nextDouble() * (double)(root.getSubteeSize() - (forbiddenTree == null ? 0 : forbiddenTree.getSubteeSize()))) + 1;
        MarkableBaseNode found = this.doGetRandomNode(pos, root, markMask, forbiddenTree);
        if (found == null && markMask > 0) {
            found = this.doGetRandomNode(Integer.MIN_VALUE, root, markMask, forbiddenTree);
        }
        for (MarkableBaseNode _n = found; _n != null; _n = (MarkableBaseNode)_n.getParent()) {
            if (_n != forbiddenTree) continue;
            throw new IllegalStateException("found in forbidden tree");
        }
        return found;
    }

    protected MarkableBaseNode doGetRandomNode(int pos, MarkableBaseNode n, int markMask, MarkableBaseNode forbiddenTree) {
        if (n == null || n == forbiddenTree) {
            throw new IllegalArgumentException(n == null ? "n==null" : "recursed into forbidden tree");
        }
        if (pos == Integer.MIN_VALUE) {
            if ((n.getMark() & markMask) == 0) {
                return n;
            }
            MarkableBaseNode found = null;
            for (int i = 0; i < n.getChildCount() && found == null; ++i) {
                MarkableBaseNode child = (MarkableBaseNode)n.getChild(i);
                if (child == forbiddenTree) continue;
                found = this.doGetRandomNode(pos, child, markMask, forbiddenTree);
            }
            return found;
        }
        if (--pos == 0) {
            if ((n.getMark() & markMask) != 0) {
                return this.doGetRandomNode(Integer.MIN_VALUE, n, markMask, forbiddenTree);
            }
            return n;
        }
        int stSize = 0;
        MarkableBaseNode child = null;
        if (n.getChildCount() == 0 || n.getChildCount() == 1 && n.getChild(0) == forbiddenTree) {
            return null;
        }
        for (int i = 0; i < n.getChildCount() && pos > 0; ++i) {
            MarkableBaseNode candidate = (MarkableBaseNode)n.getChild(i);
            if (candidate == forbiddenTree) continue;
            child = candidate;
            stSize = child.getSubteeSize();
            pos -= stSize;
        }
        if (child == null) {
            System.err.println("ARGH! pos=" + (pos + stSize));
        }
        return this.doGetRandomNode(pos + stSize, child, markMask, forbiddenTree);
    }

    protected MarkableBaseNode getLargestDelTree(MarkableBaseNode n) {
        boolean allSubtreesDeletable = true;
        MarkableBaseNode largest = null;
        for (int i = 0; i < n.getChildCount(); ++i) {
            MarkableBaseNode delRoot = this.getLargestDelTree((MarkableBaseNode)n.getChild(i));
            allSubtreesDeletable &= delRoot == n.getChild(i);
            if (largest != null && (delRoot == null || largest.getSubteeSize() >= delRoot.getSubteeSize())) continue;
            largest = delRoot;
        }
        if (allSubtreesDeletable && !n.isMarked()) {
            return n;
        }
        return largest;
    }

    private void _checkNotMarked(MarkableBaseNode n) {
        if (n.isMarked()) {
            throw new RuntimeException("ASSERT FAILED");
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            this._checkNotMarked((MarkableBaseNode)n.getChild(i));
        }
    }

    private boolean _treeHasNoCopyOf(BaseNode root, BaseNode forbiddenNode, boolean left) {
        HashSet<BaseNode> forbidden = new HashSet<BaseNode>();
        while (forbiddenNode != null) {
            forbidden.add(forbiddenNode);
            forbiddenNode = forbiddenNode.getParent();
        }
        MatchedNodes m = left ? root.getLeft() : root.getRight();
        for (BranchNode match : m.getMatches()) {
            if (this._treeHasNoCopyOf(match, forbidden)) continue;
            return false;
        }
        return true;
    }

    private boolean _treeHasNoCopyOf(BranchNode root, Set forbidden) {
        if (root == null) {
            return true;
        }
        if (forbidden.contains(root.getBaseMatch())) {
            return false;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (this._treeHasNoCopyOf(root.getChild(i), forbidden)) continue;
            return false;
        }
        return true;
    }

    protected void editTrees(MarkableBaseNode src, MarkableBaseNode dest, Node insTree, boolean after, boolean cloneInsTree, EditLog mergeLog, EditLog branchLog) {
        this.doEditTrees(src, dest, after, insTree, cloneInsTree, true, mergeLog);
        this.doEditTrees(src, dest, after, insTree, cloneInsTree, false, branchLog);
    }

    private void doEditTrees(MarkableBaseNode src, MarkableBaseNode dest, boolean after, Node insTree, boolean cloneInsTree, boolean left, EditLog log) {
        MatchedNodes m = null;
        if (src != null) {
            MatchedNodes matchedNodes = m = left ? src.getLeft() : src.getRight();
            if (dest == null) {
                log.delete(src, m.getFullMatch().getParent());
            }
            for (BranchNode match : m.getMatches()) {
                insTree = match;
                match.getParent().removeChild(match.getChildPos());
            }
            m.getMatches().clear();
        }
        if (dest != null) {
            m = left ? dest.getLeft() : dest.getRight();
            Iterator i = m.getMatches().iterator();
            while (i.hasNext()) {
                BranchNode match;
                match = null;
                try {
                    match = (BranchNode)i.next();
                }
                catch (Exception x) {
                    System.err.println("EXCEPT: " + x);
                }
                int ix = match.getChildPos() + (after ? 1 : 0);
                if (!cloneInsTree) {
                    if (src != null) {
                        throw new IllegalStateException("Currently unneccessary/unimplemented state");
                    }
                    match.getParent().addChild(ix, insTree);
                    continue;
                }
                BranchNode insRoot = this.clonedAndMatchedTree(insTree instanceof BaseNode ? (left ? ((BaseNode)insTree).getLeft().getFullMatch() : ((BaseNode)insTree).getRight().getFullMatch()) : insTree, left, false, src != null && this.useIdAttribute && this.copyModifiesId, dest);
                match.getParent().addChild(ix, insRoot);
                if (src == null) {
                    if (insTree instanceof BaseNode) {
                        log.copy(insRoot);
                        continue;
                    }
                    log.insert(insRoot);
                    continue;
                }
                log.move(insRoot);
            }
        }
    }

    protected BranchNode clonedAndMatchedTree(Node n, boolean left, boolean resetMatches, boolean allocNewIds, BaseNode _forbidden) {
        BaseNode b;
        BaseNode baseNode = b = n instanceof BaseNode ? (BaseNode)n : ((BranchNode)n).getBaseMatch();
        if (b == _forbidden) {
            throw new RuntimeException("TOUCHING FORBIDDEN NODE");
        }
        BranchNode nc = new BranchNode((XMLNode)n.getContent().clone());
        if (allocNewIds && nc.getContent() instanceof XMLElementNode) {
            AttributesImpl atts = (AttributesImpl)((XMLElementNode)nc.getContent()).getAttributes();
            atts.setValue(atts.getIndex("id"), this.newId());
        }
        if (b != null) {
            MatchedNodes mn;
            nc.setBaseMatch(b, 3);
            MatchedNodes matchedNodes = mn = left ? b.getLeft() : b.getRight();
            if (resetMatches) {
                mn.clearMatches();
            }
            mn.addMatch(nc);
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            nc.addChild(this.clonedAndMatchedTree(n.getChildAsNode(i), left, resetMatches, allocNewIds, _forbidden));
        }
        return nc;
    }

    void printTree(Node n, XMLPrinter p) {
        p.startDocument();
        this.doPrintTree(n.getChildAsNode(0), p);
        p.endDocument();
    }

    void doPrintTree(Node n, XMLPrinter p) {
        XMLNode c = n.getContent();
        if (c instanceof XMLTextNode) {
            XMLTextNode ct = (XMLTextNode)c;
            p.characters(ct.getText(), 0, ct.getText().length);
        } else {
            XMLElementNode ce = (XMLElementNode)c;
            p.startElement(ce.getNamespaceURI(), ce.getLocalName(), ce.getQName(), ce.getAttributes());
            for (int i = 0; i < n.getChildCount(); ++i) {
                this.doPrintTree(n.getChildAsNode(i), p);
            }
            p.endElement(ce.getNamespaceURI(), ce.getLocalName(), ce.getQName());
        }
    }

    public int countSubtreeSizes(MarkableBaseNode n) {
        int stSize = 0;
        for (int i = 0; i < n.getChildCount(); ++i) {
            stSize += this.countSubtreeSizes((MarkableBaseNode)n.getChild(i));
        }
        n.setSubtreeSize(++stSize);
        return stSize;
    }

    public void setPrettyPrint(boolean pp) {
        this.prettyPrint = pp;
    }

    public void setEditCount(int aCount) {
        if (aCount < 0) {
            throw new IllegalArgumentException("Illegal edit count");
        }
        this.useEditCount = true;
        this.editCount = aCount;
    }

    public void setProbability(double p) throws IllegalArgumentException {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Illegal probability");
        }
        this.useEditCount = false;
        this.probability = p;
    }

    public void setRandomGenerator(Random aRndGen) {
        this.rnd = aRndGen;
    }

    public void setEditLogPrefix(String aLog) {
        this.editLogPrefix = aLog;
    }

    public void setIdPrefix(String aPrefix) {
        if (aPrefix == null) {
            this.useIdAttribute = false;
        } else {
            this.useIdAttribute = true;
            this.idPrefix = aPrefix;
        }
    }

    public void setUpdateModifiesId(boolean modifies) {
        this.updateModifiesId = modifies;
    }

    public void setCopyModifiesId(boolean modifies) {
        this.copyModifiesId = modifies;
    }

    public void setOperations(String ops) throws IllegalArgumentException {
        if (ops.length() == 0) {
            throw new IllegalArgumentException("Empty operations string");
        }
        char[] newOps = new char[ops.length()];
        for (int i = 0; i < ops.length(); ++i) {
            char ch = ops.charAt(i);
            if (ALLOWED_OPS.indexOf(ch) == -1) {
                throw new IllegalArgumentException("Invalid char in operations string: " + ch);
            }
            newOps[i] = ch;
        }
        this.operations = newOps;
    }

    protected String newId() {
        return this.idPrefix + idCounter++;
    }

    private void _getByIds(Node n, String id, Set nodes) {
        if (id.equals(this._getId(n))) {
            nodes.add(n);
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            this._getByIds(n.getChildAsNode(i), id, nodes);
        }
    }

    private String _getId(Node n) {
        XMLNode c = n.getContent();
        if (c instanceof XMLElementNode) {
            XMLElementNode ce = (XMLElementNode)c;
            return ce.getAttributes().getValue("id");
        }
        return ((XMLTextNode)c).toString();
    }
}

