/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ProductFilterUtil {
    private static ProductFilterUtil INSTANCE;
    @VisibleForTesting
    static final String CLASS_ON_JIRA_CLASSPATH = "com.atlassian.jira.bc.issue.IssueService";
    @VisibleForTesting
    static final String CLASS_ON_CONFLUENCE_CLASSPATH = "com.atlassian.confluence.plugin.descriptor.MacroModuleDescriptor";
    @VisibleForTesting
    static final String CLASS_ON_REFAPP_CLASSPATH = "com.atlassian.refapp.api.ConnectionProvider";
    private final Log log = LogFactory.getLog(this.getClass());
    private AtomicReference<ProductFilter> filterForProduct = new AtomicReference();
    private static final Map<String, ProductFilter> PRODUCTS_TO_HOSTCLASSES;

    private ProductFilterUtil() {
    }

    public static ProductFilter getFilterForCurrentProduct(BundleContext bundleContext) {
        return ProductFilterUtil.getInstance().getFilterForProduct(bundleContext);
    }

    public static String getLowerCurrentProductName(BundleContext bundleContext) {
        ProductFilter filter = ProductFilterUtil.getFilterForCurrentProduct(bundleContext);
        if (null == filter) {
            return "";
        }
        return filter.name().toLowerCase();
    }

    public ProductFilter getFilterForProduct(BundleContext bundleContext) {
        ProductFilter productFilter = this.filterForProduct.get();
        if (productFilter == null) {
            this.filterForProduct.compareAndSet(productFilter, this.detectProduct(bundleContext));
            productFilter = this.filterForProduct.get();
        }
        return productFilter;
    }

    private ProductFilter detectProduct(BundleContext bundleContext) {
        for (Map.Entry<String, ProductFilter> entry : PRODUCTS_TO_HOSTCLASSES.entrySet()) {
            if (!this.detectService(bundleContext, entry.getKey())) continue;
            this.log.info((Object)("Detected product: " + entry.getValue().name()));
            return entry.getValue();
        }
        this.log.info((Object)"Couldn't detect product, will use ProductFilter.ALL");
        return ProductFilter.ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectService(BundleContext bundleContext, String serviceClassName) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, serviceClassName, null);
        try {
            tracker.open();
            Object hostComponent = tracker.getService();
            boolean bl = hostComponent != null;
            return bl;
        }
        finally {
            tracker.close();
        }
    }

    private static ProductFilterUtil getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new ProductFilterUtil();
        }
        return INSTANCE;
    }

    static {
        PRODUCTS_TO_HOSTCLASSES = ImmutableMap.builder().put((Object)CLASS_ON_JIRA_CLASSPATH, (Object)ProductFilter.JIRA).put((Object)CLASS_ON_CONFLUENCE_CLASSPATH, (Object)ProductFilter.CONFLUENCE).put((Object)CLASS_ON_REFAPP_CLASSPATH, (Object)ProductFilter.REFAPP).build();
    }
}

