/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat.clustered;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.compat.CompatibilityPluginScheduler;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobHandlerKey;
import com.atlassian.scheduler.compat.JobInfo;
import com.atlassian.scheduler.compat.clustered.ClusteredJobRunner;
import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredCompatibilityPluginScheduler
implements CompatibilityPluginScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteredCompatibilityPluginScheduler.class);
    private static final String JOB_RUNNER_KEY_PREFIX = "CompatibilityPluginScheduler.JobRunnerKey.";
    private static final String JOB_ID_PREFIX = "CompatibilityPluginScheduler.JobId.";
    private final SchedulerService schedulerService;

    public ClusteredCompatibilityPluginScheduler() {
        this((SchedulerService)ComponentLocator.getComponent(SchedulerService.class));
    }

    @VisibleForTesting
    ClusteredCompatibilityPluginScheduler(SchedulerService schedulerService) {
        this.schedulerService = (SchedulerService)Assertions.notNull((String)"schedulerService", (Object)schedulerService);
    }

    @Override
    public void registerJobHandler(JobHandlerKey jobHandlerKey, JobHandler jobHandler) {
        Assertions.notNull((String)"jobHandlerKey", (Object)jobHandlerKey);
        Assertions.notNull((String)"jobHandler", (Object)jobHandler);
        JobRunnerKey jobRunnerKey = ClusteredCompatibilityPluginScheduler.toJobRunnerKey(jobHandlerKey);
        if (this.isRegistered(jobRunnerKey)) {
            throw new IllegalArgumentException("Job handler already registered: " + jobHandlerKey);
        }
        this.schedulerService.registerJobRunner(jobRunnerKey, (JobRunner)new ClusteredJobRunner(jobHandler));
    }

    @Override
    public void unregisterJobHandler(JobHandlerKey jobHandlerKey) {
        this.schedulerService.unregisterJobRunner(ClusteredCompatibilityPluginScheduler.toJobRunnerKey(jobHandlerKey));
    }

    @Override
    public void scheduleClusteredJob(String jobKey, JobHandlerKey jobHandlerKey, Date startTime, long repeatInterval) {
        JobRunnerKey jobRunnerKey = ClusteredCompatibilityPluginScheduler.toJobRunnerKey(jobHandlerKey);
        if (!this.isRegistered(jobRunnerKey)) {
            throw new IllegalArgumentException("Job handler not registered: " + jobHandlerKey);
        }
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)repeatInterval, (Date)startTime));
        try {
            this.schedulerService.scheduleJob(ClusteredCompatibilityPluginScheduler.toJobId(jobKey), jobConfig);
        }
        catch (SchedulerServiceException sse) {
            LOG.error("Error scheduling job " + jobKey, (Throwable)sse);
        }
    }

    @Override
    @Nullable
    public JobInfo getJobInfo(String jobKey) {
        JobDetails jobDetails = this.schedulerService.getJobDetails(ClusteredCompatibilityPluginScheduler.toJobId(jobKey));
        if (jobDetails == null || !jobDetails.isRunnable() || jobDetails.getRunMode() != RunMode.RUN_ONCE_PER_CLUSTER || jobDetails.getSchedule().getType() != Schedule.Type.INTERVAL) {
            return null;
        }
        IntervalScheduleInfo interval = jobDetails.getSchedule().getIntervalScheduleInfo();
        return new JobInfo(jobKey, ClusteredCompatibilityPluginScheduler.toJobHandlerKey(jobDetails.getJobRunnerKey()), interval.getFirstRunTime(), interval.getIntervalInMillis());
    }

    @Override
    public void unscheduleClusteredJob(String jobKey) {
        this.schedulerService.unscheduleJob(ClusteredCompatibilityPluginScheduler.toJobId(jobKey));
    }

    private boolean isRegistered(JobRunnerKey jobRunnerKey) {
        return this.schedulerService.getRegisteredJobRunnerKeys().contains(jobRunnerKey);
    }

    static JobRunnerKey toJobRunnerKey(JobHandlerKey jobHandlerKey) {
        return JobRunnerKey.of((String)(JOB_RUNNER_KEY_PREFIX + Assertions.notNull((String)"jobHandlerKey", (Object)jobHandlerKey)));
    }

    static JobId toJobId(String jobKey) {
        return JobId.of((String)(JOB_ID_PREFIX + (String)Assertions.notNull((String)"jobKey", (Object)jobKey)));
    }

    static JobHandlerKey toJobHandlerKey(JobRunnerKey jobRunnerKey) {
        String s = ((JobRunnerKey)Assertions.notNull((String)"jobRunnerKey", (Object)jobRunnerKey)).toString();
        if (s.length() > JOB_RUNNER_KEY_PREFIX.length() && s.startsWith(JOB_RUNNER_KEY_PREFIX)) {
            return JobHandlerKey.of(s.substring(JOB_RUNNER_KEY_PREFIX.length()));
        }
        throw new IllegalArgumentException("Job runner key belongs to somebody else: " + jobRunnerKey);
    }

    static String toJobKey(JobId jobId) {
        String s = ((JobId)Assertions.notNull((String)"jobId", (Object)jobId)).toString();
        if (s.length() > JOB_ID_PREFIX.length() && s.startsWith(JOB_ID_PREFIX)) {
            return s.substring(JOB_ID_PREFIX.length());
        }
        throw new IllegalArgumentException("Job ID belongs to somebody else: " + jobId);
    }
}

