/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.shared.servlet;

import com.atlassian.oauth.shared.servlet.Message;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAdminServlet
extends HttpServlet {
    private final UserManager userManager;
    protected final MessageFactory messageFactory;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;

    public AbstractAdminServlet(UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.messageFactory = (MessageFactory)Preconditions.checkNotNull((Object)messageFactory, (Object)"messageFactory");
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider, (Object)"loginUriProvider");
        this.webSudoManager = (WebSudoManager)Preconditions.checkNotNull((Object)webSudoManager, (Object)"webSudoManager");
    }

    protected void doRestrictedPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void doRestrictedGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAdmin(request)) {
            URI returnUri = URI.create(request.getServletPath() + (request.getQueryString() != null ? "?" + request.getQueryString() : ""));
            response.sendRedirect(this.loginUriProvider.getLoginUri(returnUri).toString());
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            this.doRestrictedGet(request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAdmin(request)) {
            response.sendError(401);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            this.doRestrictedPost(request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private boolean isAdmin(HttpServletRequest req) {
        String user = this.userManager.getRemoteUsername(req);
        return user != null && this.userManager.isSystemAdmin(user);
    }

    protected final String checkRequiredParameter(HttpServletRequest request, String parameterName, Map<String, Message> errorMessages, String messageKey) {
        if (StringUtils.isBlank((String)request.getParameter(parameterName))) {
            errorMessages.put(parameterName, this.messageFactory.newMessage(messageKey, new Serializable[0]));
        }
        return request.getParameter(parameterName);
    }

    protected URI getParameterAsUri(HttpServletRequest req, String parameterName, Map<String, Message> fieldErrorMessages) {
        String uriParam = req.getParameter(parameterName);
        URI callback = null;
        try {
            callback = new URI(uriParam);
        }
        catch (URISyntaxException e) {
            fieldErrorMessages.put(parameterName, this.messageFactory.newMessage("invalid.uri", new Serializable[]{e.getMessage()}));
        }
        return callback;
    }
}

