/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge;

import com.atlassian.oauth.Request;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;

public final class Requests {
    private static final Function<Map.Entry<String, String>, Request.Parameter> toRequestParameters = new Function<Map.Entry<String, String>, Request.Parameter>(){

        public Request.Parameter apply(Map.Entry<String, String> p) {
            Preconditions.checkNotNull(p, (Object)"parameter");
            return new Request.Parameter(p.getKey(), p.getValue());
        }
    };
    private static final Function<Request.Parameter, OAuth.Parameter> toOAuthParameters = new Function<Request.Parameter, OAuth.Parameter>(){

        public OAuth.Parameter apply(Request.Parameter p) {
            Preconditions.checkNotNull((Object)p, (Object)"parameter");
            return new OAuth.Parameter(p.getName(), p.getValue());
        }
    };

    private Requests() {
    }

    public static Iterable<OAuth.Parameter> asOAuthParameters(Iterable<Request.Parameter> requestParameters) {
        Preconditions.checkNotNull(requestParameters, (Object)"requestParameters");
        return Iterables.transform(requestParameters, toOAuthParameters);
    }

    public static Iterable<Request.Parameter> fromOAuthParameters(List<? extends Map.Entry<String, String>> oauthParameters) {
        Preconditions.checkNotNull(oauthParameters, (Object)"oauthParameters");
        return Iterables.transform(oauthParameters, toRequestParameters);
    }

    public static OAuthMessage asOAuthMessage(Request request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return new OAuthMessage(request.getMethod().name(), request.getUri().toString(), (Collection)ImmutableList.copyOf(Requests.asOAuthParameters(request.getParameters())));
    }

    public static Request fromOAuthMessage(OAuthMessage message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        try {
            return new Request(Request.HttpMethod.valueOf((String)message.method.toUpperCase()), URI.create(message.URL), Requests.fromOAuthParameters(message.getParameters()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert from OAuthMessage", e);
        }
    }
}

