/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.sal.api.ApplicationProperties;

public final class HttpTimeoutsProvider {
    public static final String SYSTEM_PROPERTY_PREFIX = "atlassian.";
    public static final String SOCKET_TIMEOUT_PROPERTY_KEY = "http.socket.timeout";
    public static final String CONNECTION_TIMEOUT_PROPERTY_KEY = "http.connection.timeout";
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 15000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private final ApplicationProperties applicationProperties;

    public HttpTimeoutsProvider(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public int getConnectionTimeout() {
        return this.getIntProperty(CONNECTION_TIMEOUT_PROPERTY_KEY, 5000);
    }

    public int getSocketTimeout() {
        return this.getIntProperty(SOCKET_TIMEOUT_PROPERTY_KEY, 15000);
    }

    private int getIntProperty(String propertyKey, int defaultValue) {
        String applicationProperty = this.getProperty(propertyKey);
        Integer propertyValue = this.safeGetInt(System.getProperty(propertyKey));
        if (propertyValue == null) {
            propertyValue = this.safeGetInt(applicationProperty);
        }
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    private String getProperty(String propertyKey) {
        String propertyValue;
        try {
            propertyValue = this.applicationProperties.getPropertyValue(propertyKey);
        }
        catch (UnsupportedOperationException e) {
            propertyValue = System.getProperty(SYSTEM_PROPERTY_PREFIX + propertyKey);
        }
        return propertyValue;
    }

    private Integer safeGetInt(String intAsString) {
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

