/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.ContainerConfigException;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonHandler
extends DataRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)PersonHandler.class.getName());
    private final PersonService personService;
    private static final String PEOPLE_PATH = "/people/{userId}+/{groupId}/{personId}+";
    private static final String PEOPLE_SUP_FIELDS_REGEX = "/people/@supportedFields";
    private static Pattern peoplePatternSupFields = Pattern.compile("/people/@supportedFields");
    private Object personFields = null;

    @Inject
    public PersonHandler(PersonService personService, ContainerConf containerConf) {
        super(containerConf);
        this.personService = personService;
    }

    @Override
    protected Future<?> handleDelete(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.BAD_REQUEST, "You can't delete people.");
    }

    @Override
    protected Future<?> handlePut(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "You can't update right now.");
    }

    @Override
    protected Future<?> handlePost(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "You can't add people right now.");
    }

    @Override
    protected Future<?> handleGet(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(PEOPLE_PATH);
        if (request instanceof RestfulRequestItem && this.isValidSupportedFieldsRestCall(request)) {
            if (this.personFields == null) {
                logger.error("personFieldsList is null");
                try {
                    this.personFields = this.containerConf.getPersonFields();
                }
                catch (ContainerConfigException e) {
                    throw new SocialSpiException(ResponseError.INTERNAL_ERROR, "Error trying to Supported Person Fields from container.js", e);
                }
            }
            return ImmediateFuture.newInstance((Object)this.personFields);
        }
        GroupId groupId = request.getGroup();
        LinkedHashSet optionalPersonId = Sets.newLinkedHashSet(request.getListParameter("personId"));
        Set<String> fields = request.getFields(Person.Field.DEFAULT_FIELDS);
        Set<UserId> userIds = request.getUsers();
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        if (userIds.size() > 1 && !optionalPersonId.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch personIds for multiple userIds");
        }
        CollectionOptions options = new CollectionOptions(request);
        if (userIds.size() == 1) {
            if (optionalPersonId.isEmpty()) {
                if (groupId.getType() == GroupId.Type.self) {
                    return this.personService.getPerson(userIds.iterator().next(), fields, request.getToken());
                }
                return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
            }
            if (optionalPersonId.size() == 1) {
                return this.personService.getPerson(new UserId(UserId.Type.userId, (String)optionalPersonId.iterator().next()), fields, request.getToken());
            }
            LinkedHashSet personIds = Sets.newLinkedHashSet();
            for (String pid : optionalPersonId) {
                personIds.add(new UserId(UserId.Type.userId, pid));
            }
            return this.personService.getPeople(personIds, new GroupId(GroupId.Type.self, null), options, fields, request.getToken());
        }
        return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
    }

    private boolean isValidSupportedFieldsRestCall(RequestItem request) {
        String url = ((RestfulRequestItem)request).getUrl();
        Matcher supFieldsMatcher = peoplePatternSupFields.matcher(url);
        boolean isValidSupFieldsUrl = supFieldsMatcher.matches();
        return isValidSupFieldsUrl;
    }
}

