/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.opensocial.service.ApiServlet;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.ResponseItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServiceServlet
extends ApiServlet {
    protected static final String FORMAT_PARAM = "format";
    protected static final String ATOM_FORMAT = "atom";
    protected static final String XML_FORMAT = "xml";
    public static final String PEOPLE_ROUTE = "people";
    public static final String ACTIVITY_ROUTE = "activities";
    public static final String APPDATA_ROUTE = "appdata";
    public static final String CONTENT_TYPE = "CONTENT_TYPE";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.apache.shindig.social.opensocial.spi");

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doPost(servletRequest, servletResponse);
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doPost(servletRequest, servletResponse);
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doPost(servletRequest, servletResponse);
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        logger.info("Handling restful request for " + servletRequest.getPathInfo());
        this.setCharacterEncodings(servletRequest, servletResponse);
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        BeanConverter converter = this.getConverterForRequest(servletRequest);
        this.handleSingleRequest(servletRequest, servletResponse, token, converter);
    }

    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        servletResponse.sendError(responseItem.getError().getHttpErrorCode(), responseItem.getErrorMessage());
    }

    private void handleSingleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token, BeanConverter converter) throws IOException {
        RestfulRequestItem requestItem = new RestfulRequestItem(servletRequest, token, converter);
        ResponseItem responseItem = this.getResponseItem(this.handleRequestItem(requestItem, servletRequest));
        servletResponse.setContentType(converter.getContentType());
        if (responseItem.getError() == null) {
            PrintWriter writer = servletResponse.getWriter();
            Object response = responseItem.getResponse();
            if (!(response instanceof DataCollection) && !(response instanceof RestfulCollection)) {
                response = ImmutableMap.of((Object)"entry", (Object)response);
            }
            writer.write(converter.convertToString(response));
        } else {
            this.sendError(servletResponse, responseItem);
        }
    }

    BeanConverter getConverterForRequest(HttpServletRequest servletRequest) {
        String formatString = null;
        BeanConverter converter = null;
        String contentType = null;
        try {
            formatString = servletRequest.getParameter(FORMAT_PARAM);
        }
        catch (Throwable t) {
            logger.error("Unexpected error : format param is null " + t.toString());
        }
        try {
            contentType = servletRequest.getHeader(CONTENT_TYPE);
        }
        catch (Throwable t) {
            logger.error("Unexpected error : content type is null " + t.toString());
        }
        if (contentType != null) {
            if (contentType.equals("application/json")) {
                converter = this.jsonConverter;
            } else if (contentType.equals("application/atom+xml")) {
                converter = this.atomConverter;
            } else if (contentType.equals("application/xml")) {
                converter = this.xmlConverter;
            } else if (formatString == null) {
                converter = this.jsonConverter;
            }
        } else {
            converter = formatString != null ? (formatString.equals(ATOM_FORMAT) ? this.atomConverter : (formatString.equals(XML_FORMAT) ? this.xmlConverter : this.jsonConverter)) : this.jsonConverter;
        }
        return converter;
    }
}

