/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.betwixt.IntrospectionConfiguration;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanXmlConverter
implements BeanConverter {
    private static Logger logger = LoggerFactory.getLogger((String)BeanXmlConverter.class.getName());

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToXml(pojo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertToXml(Object obj) {
        StringWriter outputWriter = new StringWriter();
        BeanWriter writer = new BeanWriter((Writer)outputWriter);
        IntrospectionConfiguration configuration = writer.getXMLIntrospector().getConfiguration();
        configuration.setAttributesForPrimitives(false);
        configuration.setWrapCollectionsInElement(true);
        writer.getBindingConfiguration().setMapIDs(false);
        writer.setEndOfLine("");
        writer.setWriteEmptyElements(false);
        String toReturn = null;
        try {
            writer.write("response", obj);
            toReturn = outputWriter.toString();
            logger.info("XML is: " + toReturn + "\n **** \n\n");
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IntrospectionException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return toReturn;
    }

    @Override
    public <T> T convertToObject(String xml, Class<T> className) {
        String errorMessage = "Could not convert " + xml + " to " + className;
        BeanReader reader = new BeanReader();
        try {
            reader.registerBeanClass("activity", className);
            StringReader rd = new StringReader(xml);
            return (T)reader.parse((Reader)rd);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (IOException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (SAXException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }
}

