/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;
import org.apache.shindig.social.core.util.xstream.StackDriver;
import org.apache.shindig.social.core.util.xstream.ThreadSafeWriterStack;
import org.apache.shindig.social.core.util.xstream.WriterStack;
import org.apache.shindig.social.core.util.xstream.XStreamConfiguration;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanXStreamConverter
implements BeanConverter {
    public static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final XStreamConfiguration.ConverterSet[] MAPPER_SCOPES = new XStreamConfiguration.ConverterSet[]{XStreamConfiguration.ConverterSet.MAP, XStreamConfiguration.ConverterSet.COLLECTION, XStreamConfiguration.ConverterSet.DEFAULT};
    private static Logger log = LoggerFactory.getLogger(BeanXStreamConverter.class);
    private ReflectionProvider rp;
    private HierarchicalStreamDriver driver;
    protected WriterStack writerStack;
    protected Map<XStreamConfiguration.ConverterSet, XStreamConfiguration.ConverterConfig> converterMap = Maps.newHashMap();

    @Inject
    public BeanXStreamConverter(XStreamConfiguration configuration) {
        this.rp = new PureJavaReflectionProvider();
        DefaultMapper dmapper = new DefaultMapper(this.getClass().getClassLoader());
        this.writerStack = new ThreadSafeWriterStack();
        this.driver = new StackDriver((HierarchicalStreamDriver)new XppDriver(), this.writerStack, configuration.getNameSpaces());
        for (XStreamConfiguration.ConverterSet c : MAPPER_SCOPES) {
            this.converterMap.put(c, configuration.getConverterConfig(c, this.rp, (Mapper)dmapper, this.driver, this.writerStack));
        }
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToXml(pojo);
    }

    private String convertToXml(Object obj) {
        this.writerStack.reset();
        if (obj instanceof Map) {
            Map m = (Map)obj;
            XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.MAP);
            if (m.size() == 1) {
                Object s = m.values().iterator().next();
                cc.mapper.setBaseObject(s);
                String result = cc.xstream.toXML(s);
                log.debug("Result is " + result);
                return "<response>" + result + "</response>";
            }
        } else {
            if (obj instanceof RestfulCollection) {
                XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.COLLECTION);
                cc.mapper.setBaseObject(obj);
                String result = cc.xstream.toXML(obj);
                log.debug("Result is " + result);
                return result;
            }
            if (obj instanceof DataCollection) {
                XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.MAP);
                cc.mapper.setBaseObject(obj);
                String result = cc.xstream.toXML(obj);
                log.debug("Result is " + result);
                return result;
            }
        }
        XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        cc.mapper.setBaseObject(obj);
        String result = cc.xstream.toXML(obj);
        log.debug("Result is " + result);
        return "<response>" + result + "</response>";
    }

    @Override
    public <T> T convertToObject(String xml, Class<T> className) {
        XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        return (T)cc.xstream.fromXML(xml);
    }
}

