/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import java.lang.reflect.Array;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.JSONUtils;
import org.apache.shindig.social.core.util.JsonLibConverterUtils;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanJsonLibConverter
implements BeanConverter {
    protected static final Logger LOG = LoggerFactory.getLogger(BeanJsonLibConverter.class);
    private Injector injector;
    private JsonConfig jsonConfig;
    private boolean debugMode = false;

    @Inject
    public BeanJsonLibConverter(Injector injector, @Named(value="ShindigJsonConfig") JsonConfig jsonConfig) {
        this.injector = injector;
        this.jsonConfig = jsonConfig;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public <T> T convertToObject(String string, Class<T> rootBeanClass) {
        if ("".equals(string)) {
            string = "{}";
        }
        if (string.startsWith("[")) {
            JSONArray jsonArray = JSONArray.fromObject((Object)string, (JsonConfig)this.jsonConfig);
            if (this.debugMode) {
                JsonLibConverterUtils.dumpJsonArray(jsonArray, " ");
            }
            if (rootBeanClass.isArray()) {
                Class<?> componentType = rootBeanClass.getComponentType();
                Object rootObject = this.injector.getInstance(componentType);
                List o = JSONArray.toList((JSONArray)jsonArray, (Object)rootObject, (JsonConfig)this.jsonConfig);
                Object[] result = (Object[])Array.newInstance(componentType, o.size());
                for (int i = 0; i < o.size(); ++i) {
                    result[i] = o.get(i);
                }
                return (T)result;
            }
            Object rootObject = this.injector.getInstance(rootBeanClass);
            Object o = JSONArray.toArray((JSONArray)jsonArray, (Object)rootObject, (JsonConfig)this.jsonConfig);
            return (T)o;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)string, (JsonConfig)this.jsonConfig);
        if (this.debugMode) {
            JsonLibConverterUtils.dumpJsonObject(jsonObject, " ");
        }
        Object rootObject = this.injector.getInstance(rootBeanClass);
        Object o = JSONObject.toBean((JSONObject)jsonObject, (Object)rootObject, (JsonConfig)this.jsonConfig);
        return (T)o;
    }

    @Override
    public String convertToString(Object pojo) {
        if ("".equals(pojo)) {
            return "{}";
        }
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)pojo, (JsonConfig)this.jsonConfig);
            return jsonObject.toString();
        }
        catch (JSONException jse) {
            Class<?> pojoClass = pojo.getClass();
            if (JSONUtils.isArray(pojoClass)) {
                JSONArray jsonArray = JSONArray.fromObject((Object)pojo);
                String result = jsonArray.toString();
                return result;
            }
            throw jse;
        }
    }

    public void addMapping(String key, Class<?> class1) {
        this.jsonConfig.getClassMap().put(key, class1);
    }
}

