/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthMessage;
import net.oauth.server.OAuthServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthLookupService;

public class OAuthConsumerRequestAuthenticationHandler
implements AuthenticationHandler {
    public static final String AUTH_OAUTH_CONSUMER_REQUEST = "OAuth-ConsumerRequest";
    public static final String REQUESTOR_ID_PARAM = "xoauth_requestor_id";
    private final OAuthLookupService service;

    @Inject
    public OAuthConsumerRequestAuthenticationHandler(OAuthLookupService service) {
        this.service = service;
    }

    public String getName() {
        return AUTH_OAUTH_CONSUMER_REQUEST;
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) {
        OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)request, null);
        String containerKey = this.getParameter(requestMessage, "oauth_consumer_key");
        String containerSignature = this.getParameter(requestMessage, "oauth_signature");
        String userId = StringUtils.trim((String)request.getParameter(REQUESTOR_ID_PARAM));
        if (containerKey == null || containerSignature == null || StringUtils.isBlank((String)userId)) {
            return null;
        }
        if (this.service.thirdPartyHasAccessToUser(requestMessage, containerKey, userId)) {
            return this.service.getSecurityToken(containerKey, userId);
        }
        return null;
    }

    public String getWWWAuthenticateHeader(String realm) {
        return String.format("OAuth realm=\"%s\"", realm);
    }

    private String getParameter(OAuthMessage requestMessage, String key) {
        try {
            return requestMessage.getParameter(key);
        }
        catch (IOException e) {
            return null;
        }
    }
}

