/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.servlet.HttpUtil;

public class JsServlet
extends InjectedServlet {
    private GadgetFeatureRegistry registry;

    @Inject
    public void setRegistry(GadgetFeatureRegistry registry) {
        this.registry = registry;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader("If-Modified-Since") != null && req.getParameter("v") != null) {
            resp.setStatus(304);
            return;
        }
        String uri = req.getRequestURI();
        String resourceName = uri.substring(uri.lastIndexOf(47) + 1);
        if (resourceName.endsWith(".js")) {
            resourceName = resourceName.substring(0, resourceName.length() - ".js".length());
        }
        ImmutableSet needed = ImmutableSet.copyOf((Object[])resourceName.split(":"));
        String debugStr = req.getParameter("debug");
        String container = req.getParameter("container");
        String containerStr = req.getParameter("c");
        boolean debug = "1".equals(debugStr);
        if (container == null) {
            container = "default";
        }
        RenderingContext context = "1".equals(containerStr) ? RenderingContext.CONTAINER : RenderingContext.GADGET;
        Collection<GadgetFeature> features = this.registry.getFeatures((Collection<String>)needed);
        StringBuilder jsData = new StringBuilder();
        for (GadgetFeature feature : features) {
            for (JsLibrary lib : feature.getJsLibraries(context, container)) {
                if (lib.getType().equals((Object)JsLibrary.Type.URL)) continue;
                if (debug) {
                    jsData.append(lib.getDebugContent());
                } else {
                    jsData.append(lib.getContent());
                }
                jsData.append(";\n");
            }
        }
        if (jsData.length() == 0) {
            resp.setStatus(404);
            return;
        }
        if (req.getParameter("v") != null) {
            HttpUtil.setCachingHeaders(resp);
        } else {
            HttpUtil.setCachingHeaders(resp, 3600);
        }
        resp.setContentType("text/javascript; charset=utf-8");
        byte[] response = jsData.toString().getBytes("UTF-8");
        resp.setContentLength(response.length);
        resp.getOutputStream().write(response);
    }
}

