/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkingTagRewriter
implements HtmlTagTransformer {
    private final Uri relativeBase;
    private final LinkRewriter linkRewriter;
    private final Map<String, Set<String>> tagAttributeTargets;
    private final StringBuilder builder;
    private Set<String> currentTagAttrs;

    public static Map<String, Set<String>> getDefaultTargets() {
        ImmutableMap targets = new ImmutableMap.Builder().put((Object)"img", (Object)ImmutableSet.of((Object)"src")).put((Object)"embed", (Object)ImmutableSet.of((Object)"src")).put((Object)"link", (Object)ImmutableSet.of((Object)"href")).build();
        return targets;
    }

    public LinkingTagRewriter(LinkRewriter linkRewriter, Uri relativeBase) {
        this(LinkingTagRewriter.getDefaultTargets(), linkRewriter, relativeBase);
    }

    public LinkingTagRewriter(Map<String, Set<String>> tagAttributeTargets, LinkRewriter linkRewriter, Uri relativeBase) {
        this.tagAttributeTargets = tagAttributeTargets;
        this.linkRewriter = linkRewriter;
        this.relativeBase = relativeBase;
        this.builder = new StringBuilder(300);
    }

    public Set<String> getSupportedTags() {
        return this.tagAttributeTargets.keySet();
    }

    @Override
    public void accept(Token<HtmlTokenType> token, Token<HtmlTokenType> lastToken) {
        if (token.type == HtmlTokenType.TAGBEGIN) {
            this.currentTagAttrs = this.tagAttributeTargets.get(token.text.substring(1).toLowerCase());
        }
        if (this.currentTagAttrs != null && lastToken != null && lastToken.type == HtmlTokenType.ATTRNAME && this.currentTagAttrs.contains(lastToken.text.toLowerCase())) {
            String link = this.stripQuotes(token.text);
            this.builder.append("=\"");
            this.builder.append(this.linkRewriter.rewrite(link, this.relativeBase));
            this.builder.append('\"');
            return;
        }
        this.builder.append(HtmlRewriter.producePreTokenSeparator(token, lastToken));
        this.builder.append(token.text);
        this.builder.append(HtmlRewriter.producePostTokenSeparator(token, lastToken));
    }

    @Override
    public boolean acceptNextTag(Token<HtmlTokenType> tagStart) {
        return false;
    }

    @Override
    public String close() {
        String result = this.builder.toString();
        this.currentTagAttrs = null;
        this.builder.setLength(0);
        return result;
    }

    private String stripQuotes(String s) {
        return s.replaceAll("\"", "").replaceAll("'", "");
    }
}

