/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.Preload;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPreloader
implements Preloader {
    private final ContentFetcherFactory fetcher;

    @Inject
    public HttpPreloader(ContentFetcherFactory fetcherFactory) {
        this.fetcher = fetcherFactory;
    }

    @Override
    public Map<String, PreloadedData> createPreloadDataMap(GadgetContext context, GadgetSpec gadget) throws GadgetException {
        HashMap preloads = Maps.newHashMap();
        for (Preload preload : gadget.getModulePrefs().getPreloads()) {
            Set<String> preloadViews = preload.getViews();
            if (!preloadViews.isEmpty() && !preloadViews.contains(context.getView())) continue;
            preloads.put(preload.getHref().toString(), this.fetchPreloadData(context, preload));
        }
        return preloads;
    }

    private PreloadedData fetchPreloadData(GadgetContext context, Preload preload) throws GadgetException {
        HttpRequest request = new HttpRequest(preload.getHref()).setSecurityToken(context.getToken()).setOAuthArguments(new OAuthArguments(preload)).setAuthType(preload.getAuthType()).setContainer(context.getContainer()).setGadget(Uri.fromJavaUri((URI)context.getUrl()));
        return new HttpPreloadData(this.fetcher.fetch(request));
    }

    private static class HttpPreloadData
    implements PreloadedData {
        private final JSONObject data;

        public HttpPreloadData(HttpResponse response) {
            JSONObject data = null;
            try {
                data = FetchResponseUtils.getResponseAsJson(response, response.getResponseAsString());
            }
            catch (JSONException e) {
                data = new JSONObject();
            }
            this.data = data;
        }

        public Object toJson() {
            return this.data;
        }
    }
}

