/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Criterion;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetCssParser;
import org.apache.shindig.gadgets.parse.ParsedCssDeclaration;
import org.apache.shindig.gadgets.parse.ParsedCssRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CajaCssParser
implements GadgetCssParser {
    @Override
    public List<ParsedCssRule> parse(String css) throws GadgetException {
        if (css.matches("\\s*")) {
            return Lists.newArrayList();
        }
        CssParser parser = this.getParser(css);
        CssTree.StyleSheet stylesheet = null;
        try {
            stylesheet = parser.parseStyleSheet();
        }
        catch (ParseException e) {
            throw new GadgetException(GadgetException.Code.CSS_PARSE_ERROR, (Throwable)e);
        }
        ArrayList rules = Lists.newArrayListWithExpectedSize((int)stylesheet.children().size());
        for (CssTree node : stylesheet.children()) {
            if (!(node instanceof CssTree.RuleSet)) continue;
            rules.add(new CajaParsedCssRule((CssTree.RuleSet)node));
        }
        return rules;
    }

    @Override
    public List<ParsedCssDeclaration> parseInline(String style) throws GadgetException {
        if (style.matches("\\s*")) {
            return Lists.newArrayList();
        }
        CssParser parser = this.getParser(style);
        CssTree.DeclarationGroup declGroup = null;
        try {
            declGroup = parser.parseDeclarationGroup();
        }
        catch (ParseException e) {
            throw new GadgetException(GadgetException.Code.CSS_PARSE_ERROR, (Throwable)e);
        }
        ArrayList attributes = Lists.newArrayListWithExpectedSize((int)declGroup.children().size());
        for (CssTree node : declGroup.children()) {
            CssTree.Declaration decl;
            if (!(node instanceof CssTree.Declaration) || (decl = (CssTree.Declaration)node).getProperty() == null) continue;
            attributes.add(new CajaParsedCssDeclaration(decl));
        }
        return attributes;
    }

    private CssParser getParser(String content) {
        InputSource source = null;
        try {
            source = new InputSource(new URI("http://dummy.com/"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        CharProducer producer = CharProducer.Factory.create((Reader)new StringReader(content), (InputSource)source);
        CssLexer lexer = new CssLexer(producer);
        return new CssParser(new TokenQueue((TokenStream)lexer, source, (Criterion)new Criterion<Token<CssTokenType>>(){

            public boolean accept(Token<CssTokenType> tok) {
                return tok.type != CssTokenType.COMMENT && tok.type != CssTokenType.SPACE;
            }
        }));
    }

    private static final String renderCssTreeElement(CssTree elem) {
        StringBuffer selBuffer = new StringBuffer();
        TokenConsumer tc = elem.makeRenderer((Appendable)selBuffer, null);
        elem.render(new RenderContext(new MessageContext(), tc));
        return selBuffer.toString();
    }

    private static class CajaParsedCssDeclaration
    implements ParsedCssDeclaration {
        private final String key;
        private final String value;

        private CajaParsedCssDeclaration(CssTree.Declaration declaration) {
            this.key = declaration.getProperty().getPropertyName().getCanonicalForm();
            this.value = CajaCssParser.renderCssTreeElement((CssTree)declaration.getExpr());
        }

        public String getName() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CajaParsedCssRule
    implements ParsedCssRule {
        private final List<ParsedCssDeclaration> attributes = Lists.newArrayList();
        private final List<String> selectors = Lists.newArrayList();

        private CajaParsedCssRule(CssTree.RuleSet ruleSet) {
            for (CssTree child : ruleSet.children()) {
                CssTree.Declaration decl;
                if (child instanceof CssTree.Selector) {
                    this.selectors.add(CajaCssParser.renderCssTreeElement(child));
                    continue;
                }
                if (!(child instanceof CssTree.Declaration) || (decl = (CssTree.Declaration)child).getProperty() == null) continue;
                this.attributes.add(new CajaParsedCssDeclaration(decl));
            }
        }

        @Override
        public List<ParsedCssDeclaration> getDeclarations() {
            return this.attributes;
        }

        @Override
        public List<String> getSelectors() {
            return this.selectors;
        }
    }
}

