/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.Pairs;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthResponseParams {
    private static final Logger logger = LoggerFactory.getLogger((String)OAuthResponseParams.class.getName());
    private static final Pattern REMOVE_SECRETS = Pattern.compile("(?<=(oauth_token_secret|oauth_session_handle)=)[^=& \t\r\n]*");
    public static final String CLIENT_STATE = "oauthState";
    public static final String APPROVAL_URL = "oauthApprovalUrl";
    public static final String ERROR_CODE = "oauthError";
    public static final String ERROR_TEXT = "oauthErrorText";
    private final OAuthClientState newClientState;
    private final SecurityToken securityToken;
    private final HttpRequest originalRequest;
    private final List<Pair<HttpRequest, HttpResponse>> requestTrace = Lists.newArrayList();
    private String aznUrl;
    private String error;
    private String errorText;
    private boolean sendTraceToClient;

    public OAuthResponseParams(SecurityToken securityToken, HttpRequest originalRequest, BlobCrypter stateCrypter) {
        this.securityToken = securityToken;
        this.originalRequest = originalRequest;
        this.newClientState = new OAuthClientState(stateCrypter);
    }

    public void logDetailedWarning(String note) {
        if (logger.isWarnEnabled()) {
            logger.warn(note);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(note + '\n' + this.getDetails());
        }
    }

    public void logDetailedWarning(String note, Throwable e) {
        if (logger.isWarnEnabled()) {
            logger.warn(note + ": " + e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(note + '\n' + this.getDetails(), e);
        }
    }

    public void logDetailedInfo(String note, Throwable e) {
        if (logger.isInfoEnabled()) {
            logger.info(note + ": " + e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(note + '\n' + this.getDetails(), e);
        }
    }

    public void addRequestTrace(HttpRequest request, HttpResponse response) {
        this.requestTrace.add((Pair<HttpRequest, HttpResponse>)Pairs.newPair((Object)request, (Object)response));
    }

    public boolean sawErrorResponse() {
        for (Pair<HttpRequest, HttpResponse> event : this.requestTrace) {
            if (event.two != null && !((HttpResponse)event.two).isError()) continue;
            return true;
        }
        return false;
    }

    private String getDetails() {
        return "OAuth error [" + this.error + ", " + this.errorText + "] for application " + this.securityToken.getAppUrl() + ".  Request trace:" + this.getRequestTrace();
    }

    private String getRequestTrace() {
        StringBuilder trace = new StringBuilder();
        trace.append("\n==== Original request:\n");
        trace.append(this.originalRequest);
        trace.append("\n====");
        int i = 1;
        for (Pair<HttpRequest, HttpResponse> event : this.requestTrace) {
            trace.append("\n==== Sent request " + i + ":\n");
            if (event.one != null) {
                trace.append(OAuthResponseParams.filterSecrets(((HttpRequest)event.one).toString()));
            }
            trace.append("\n==== Received response " + i + ":\n");
            if (event.two != null) {
                trace.append(OAuthResponseParams.filterSecrets(((HttpResponse)event.two).toString()));
            }
            trace.append("\n====");
            ++i;
        }
        return trace.toString();
    }

    static String filterSecrets(String in) {
        Matcher m = REMOVE_SECRETS.matcher(in);
        return m.replaceAll("REMOVED");
    }

    public void addToResponse(HttpResponseBuilder response) {
        if (!this.newClientState.isEmpty()) {
            try {
                response.setMetadata(CLIENT_STATE, this.newClientState.getEncryptedState());
            }
            catch (BlobCrypterException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aznUrl != null) {
            response.setMetadata(APPROVAL_URL, this.aznUrl);
        }
        if (this.error != null) {
            response.setMetadata(ERROR_CODE, this.error);
        }
        if (this.errorText != null || this.sendTraceToClient) {
            StringBuilder verboseError = new StringBuilder();
            if (this.errorText != null) {
                verboseError.append(this.errorText);
            }
            if (this.sendTraceToClient) {
                verboseError.append('\n');
                verboseError.append(this.getRequestTrace());
            }
            response.setMetadata(ERROR_TEXT, verboseError.toString());
        }
    }

    public OAuthClientState getNewClientState() {
        return this.newClientState;
    }

    public String getAznUrl() {
        return this.aznUrl;
    }

    public void setAznUrl(String aznUrl) {
        this.aznUrl = aznUrl;
    }

    public boolean sendTraceToClient() {
        return this.sendTraceToClient;
    }

    public void setSendTraceToClient(boolean sendTraceToClient) {
        this.sendTraceToClient = sendTraceToClient;
    }

    public String getError() {
        return this.error;
    }

    public OAuthRequestException oauthRequestException(OAuthError error, String errorText) {
        return this.oauthRequestException(error.toString(), errorText);
    }

    public OAuthRequestException oauthRequestException(OAuthError error, String errorText, Throwable cause) {
        return this.oauthRequestException(error.toString(), errorText, cause);
    }

    public OAuthRequestException oauthRequestException(String error, String errorText) {
        this.error = (String)Preconditions.checkNotNull((Object)error);
        this.errorText = (String)Preconditions.checkNotNull((Object)errorText);
        return new OAuthRequestException('[' + error + ',' + errorText + ']');
    }

    public OAuthRequestException oauthRequestException(String error, String errorText, Throwable cause) {
        this.error = (String)Preconditions.checkNotNull((Object)error);
        this.errorText = (String)Preconditions.checkNotNull((Object)errorText);
        return new OAuthRequestException('[' + error + ',' + errorText + ']', cause);
    }

    public static class OAuthRequestException
    extends Exception {
        private OAuthRequestException(String message) {
            super(message);
        }

        private OAuthRequestException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

