/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.io.IOException;
import org.xerial.snappy.Snappy;

class CompressedByteArray {
    static final String GADGETS_COMPRESSION_ENABLED_KEY = "gadgets.compression.enabled";
    static final boolean GADGETS_COMPRESSION_ENABLED_VALUE = Boolean.getBoolean("gadgets.compression.enabled");
    private final byte[] bytes;
    private final int length;

    public CompressedByteArray(byte[] bytes) {
        this.bytes = GADGETS_COMPRESSION_ENABLED_VALUE ? (bytes != null ? CompressedByteArray.zip(bytes) : null) : bytes;
        this.length = bytes != null ? bytes.length : 0;
    }

    byte[] compressedBytes() {
        return this.bytes;
    }

    byte[] uncompressedBytes() {
        if (GADGETS_COMPRESSION_ENABLED_VALUE) {
            return this.bytes != null ? CompressedByteArray.unzip(this.bytes) : null;
        }
        return this.bytes;
    }

    int length() {
        return this.length;
    }

    private static byte[] zip(byte[] bytes) {
        try {
            return Snappy.compress((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] unzip(byte[] bytes) {
        try {
            return Snappy.uncompress((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

