/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.File;
import java.io.IOException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsLibrary {
    private final Type type;
    private final String content;
    private final String feature;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.apache.shindig.gadgets");

    public Type getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getDebugContent() {
        return this.content;
    }

    public String getFeature() {
        return this.feature;
    }

    public String toString() {
        if (this.type == Type.URL) {
            return "<script src=\"" + this.content + "\"></script>";
        }
        return "<script><!--\n" + this.content + "\n--></script>";
    }

    public static JsLibrary create(Type type, String content, String feature, HttpFetcher fetcher) throws GadgetException {
        String optimizedContent = null;
        switch (type) {
            case FILE: 
            case RESOURCE: {
                if (content.endsWith(".js")) {
                    optimizedContent = JsLibrary.loadData(content.substring(0, content.length() - 3) + ".opt.js", type);
                }
                if (optimizedContent != null && optimizedContent.length() != 0) break;
                optimizedContent = JsLibrary.loadData(content, type);
                break;
            }
            case URL: {
                if (fetcher == null) {
                    optimizedContent = content;
                    break;
                }
                type = Type.FILE;
                optimizedContent = JsLibrary.loadDataFromUrl(content, fetcher);
                break;
            }
            default: {
                optimizedContent = content;
            }
        }
        return new JsLibrary(feature, type, optimizedContent);
    }

    private static String loadData(String name, Type type) {
        logger.info("Loading js from: " + name + " type: " + type.toString());
        if (type == Type.FILE) {
            return JsLibrary.loadFile(name);
        }
        if (type == Type.RESOURCE) {
            return JsLibrary.loadResource(name);
        }
        return null;
    }

    private static String loadDataFromUrl(String url, HttpFetcher fetcher) throws GadgetException {
        try {
            logger.info("Attempting to load js from: " + url);
            Uri uri = Uri.parse((String)url);
            HttpRequest request = new HttpRequest(uri);
            HttpResponse response = fetcher.fetch(request);
            if (response.getHttpStatusCode() == 200) {
                return response.getResponseAsString();
            }
            logger.warn("Unable to retrieve remote library from " + url);
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Malformed URL: " + url, (Throwable)e);
            return null;
        }
    }

    private static String loadFile(String fileName) {
        if (fileName == null) {
            return "";
        }
        File file = new File(fileName);
        if (!file.exists()) {
            logger.warn("File not found: " + fileName);
            return null;
        }
        if (!file.isFile()) {
            logger.warn("JsLibrary is not a file: " + fileName);
            return null;
        }
        if (!file.canRead()) {
            logger.warn("JsLibrary cannot be read: " + fileName);
            return null;
        }
        try {
            return ResourceLoader.getContent((File)file);
        }
        catch (IOException e) {
            logger.warn("Error reading file: " + fileName);
            return null;
        }
    }

    private static String loadResource(String name) {
        try {
            return ResourceLoader.getContent((String)name);
        }
        catch (IOException e) {
            logger.warn("Could not find resource: " + name);
            return null;
        }
    }

    public int hashCode() {
        return this.content.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs instanceof JsLibrary) {
            JsLibrary lib = (JsLibrary)rhs;
            return this.content.equals(lib.content) && this.type.equals((Object)lib.type);
        }
        return false;
    }

    private JsLibrary(String feature, Type type, String content) {
        this.feature = feature;
        this.type = type;
        this.content = content;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        RESOURCE,
        URL,
        INLINE;


        public static Type parse(String name) {
            if ("file".equals(name)) {
                return FILE;
            }
            if ("url".equals(name)) {
                return URL;
            }
            if ("resource".equals(name)) {
                return RESOURCE;
            }
            return INLINE;
        }
    }
}

