/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URI;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Check;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultGadgetSpecFactory
implements GadgetSpecFactory {
    public static final String CACHE_NAME = "gadgetSpecs";
    static final String RAW_GADGETSPEC_XML_PARAM_NAME = "rawxml";
    static final Uri RAW_GADGET_URI = Uri.parse((String)"http://localhost/raw.xml");
    static final String ERROR_SPEC = "<Module><ModulePrefs title='Error'/><Content/></Module>";
    static final String ERROR_KEY = "parse.exception";
    static final Logger LOG = LoggerFactory.getLogger((String)DefaultGadgetSpecFactory.class.getName());
    private final HttpFetcher fetcher;
    private final SoftExpiringCache<Uri, GadgetSpec> cache;
    private final long refresh;

    @Inject
    public DefaultGadgetSpecFactory(HttpFetcher fetcher, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh) {
        this.fetcher = fetcher;
        Cache baseCache = cacheProvider.createCache(CACHE_NAME);
        this.cache = new SoftExpiringCache(baseCache);
        this.refresh = refresh;
    }

    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        String rawxml = context.getParameter(RAW_GADGETSPEC_XML_PARAM_NAME);
        if (rawxml != null) {
            return new GadgetSpec(RAW_GADGET_URI, rawxml);
        }
        return this.getGadgetSpec(context.getUrl(), context.getIgnoreCache());
    }

    public GadgetSpec getGadgetSpec(URI gadgetUri, boolean ignoreCache) throws GadgetException {
        GadgetException exception;
        Uri uri = Uri.fromJavaUri((URI)gadgetUri);
        if (ignoreCache) {
            return this.fetchObjectAndCache(uri, ignoreCache);
        }
        SoftExpiringCache.CachedObject cached = this.cache.getElement((Object)uri);
        GadgetSpec spec = null;
        if (cached == null || cached.isExpired) {
            try {
                spec = this.fetchObjectAndCache(uri, ignoreCache);
            }
            catch (GadgetException e) {
                if (cached != null) {
                    spec = (GadgetSpec)cached.obj;
                    Check.notNull((Object)spec);
                } else {
                    spec = new GadgetSpec(uri, ERROR_SPEC);
                    spec.setAttribute(ERROR_KEY, e);
                }
                LOG.info("GadgetSpec fetch failed for " + uri + " - using cached.");
                this.cache.addElement((Object)uri, (Object)spec, this.refresh);
            }
        } else {
            spec = (GadgetSpec)cached.obj;
        }
        if ((exception = (GadgetException)spec.getAttribute(ERROR_KEY)) != null) {
            throw exception;
        }
        return spec;
    }

    private GadgetSpec fetchObjectAndCache(Uri url, boolean ignoreCache) throws GadgetException {
        HttpRequest request = new HttpRequest(url).setIgnoreCache(ignoreCache);
        request.setCacheTtl((int)(this.refresh / 1000L));
        HttpResponse response = this.fetcher.fetch(request);
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve gadget xml. HTTP error " + response.getHttpStatusCode());
        }
        String checksum = HashUtil.checksum((byte[])response.getResponseAsBytes());
        GadgetSpec spec = new GadgetSpec(url, response.getResponseAsString(), checksum);
        this.cache.addElement((Object)url, (Object)spec, this.refresh);
        return spec;
    }
}

