/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.xml;

import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)XmlUtil.class.getName());
    private static final ErrorHandler errorHandler = new ErrorHandler(){

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) {
            LOG.info("XmlUtil warning", (Object)exception.toString());
        }
    };
    private static boolean canReuseBuilders = false;
    private static final DocumentBuilderFactory builderFactory = SecureXmlParserFactory.newDocumentBuilderFactory();
    private static final ThreadLocal<DocumentBuilder> reusableBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                LOG.info("Created a new document builder");
                return builderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private XmlUtil() {
    }

    public static String getAttribute(Node node, String attr, String def) {
        NamedNodeMap attrs = node.getAttributes();
        Node val = attrs.getNamedItem(attr);
        if (val != null) {
            return val.getNodeValue();
        }
        return def;
    }

    public static String getAttribute(Node node, String attr) {
        return XmlUtil.getAttribute(node, attr, null);
    }

    public static Uri getUriAttribute(Node node, String attr, Uri def) {
        String uri = XmlUtil.getAttribute(node, attr);
        if (uri != null) {
            try {
                return Uri.parse(uri);
            }
            catch (IllegalArgumentException e) {
                return def;
            }
        }
        return def;
    }

    public static Uri getUriAttribute(Node node, String attr) {
        return XmlUtil.getUriAttribute(node, attr, null);
    }

    public static Uri getHttpUriAttribute(Node node, String attr, Uri def) {
        Uri uri = XmlUtil.getUriAttribute(node, attr, def);
        if (uri == null) {
            return def;
        }
        if (!"http".equalsIgnoreCase(uri.getScheme()) && !"https".equalsIgnoreCase(uri.getScheme())) {
            return def;
        }
        return uri;
    }

    public static Uri getHttpUriAttribute(Node node, String attr) {
        return XmlUtil.getHttpUriAttribute(node, attr, null);
    }

    public static boolean getBoolAttribute(Node node, String attr, boolean def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolAttribute(Node node, String attr) {
        return XmlUtil.getBoolAttribute(node, attr, false);
    }

    public static int getIntAttribute(Node node, String attr, int def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int getIntAttribute(Node node, String attr) {
        return XmlUtil.getIntAttribute(node, attr, 0);
    }

    private static DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilder builder;
        if (canReuseBuilders) {
            builder = reusableBuilder.get();
            builder.reset();
        } else {
            builder = builderFactory.newDocumentBuilder();
        }
        builder.setErrorHandler(errorHandler);
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Element parse(String xml) throws XmlException {
        try {
            DocumentBuilder builder = XmlUtil.getBuilder();
            try {
                Element element;
                InputSource is = new InputSource(new StringReader(xml.trim()));
                Element element2 = element = builder.parse(is).getDocumentElement();
                return element2;
            }
            catch (SAXParseException e) {
                throw new XmlException(e.getMessage() + " At: (" + e.getLineNumber() + ',' + e.getColumnNumber() + ')', e);
            }
            catch (SAXException e) {
                throw new XmlException(e);
            }
            catch (IOException e) {
                throw new XmlException(e);
            }
            finally {
                if (builder != null) {
                    builder.setErrorHandler(null);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
    }

    static {
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.reset();
            canReuseBuilders = true;
            LOG.info("Reusing document builders");
        }
        catch (UnsupportedOperationException e) {
            canReuseBuilders = false;
            LOG.info("Not reusing document builders");
        }
        catch (ParserConfigurationException e) {
            canReuseBuilders = false;
            LOG.info("Not reusing document builders");
        }
    }
}

