/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;

public class StringEncoding {
    private final char[] DIGITS;
    private final int SHIFT;
    private final int MASK;

    public StringEncoding(char[] userDigits) {
        TreeSet t = Sets.newTreeSet();
        for (char c : userDigits) {
            t.add(Character.valueOf(c));
        }
        char[] digits = new char[t.size()];
        int i = 0;
        Iterator iterator = t.iterator();
        while (iterator.hasNext()) {
            char c;
            c = ((Character)iterator.next()).charValue();
            digits[i++] = c;
        }
        this.DIGITS = digits;
        this.MASK = digits.length - 1;
        this.SHIFT = Integer.numberOfTrailingZeros(this.MASK + 1);
        if (this.MASK + 1 != 1 << this.SHIFT || digits.length >= 256) {
            throw new AssertionError((Object)Arrays.toString(digits));
        }
    }

    public String encode(byte[] data) {
        if (data.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(1 + data.length * 8 / this.DIGITS.length);
        int buffer = data[0];
        int next = 1;
        for (int bitsLeft = 8; bitsLeft > 0 || next < data.length; bitsLeft -= this.SHIFT) {
            if (bitsLeft < this.SHIFT) {
                if (next < data.length) {
                    buffer <<= 8;
                    buffer |= data[next++] & 0xFF;
                    bitsLeft += 8;
                } else {
                    int pad = this.SHIFT - bitsLeft;
                    buffer <<= pad;
                    bitsLeft += pad;
                }
            }
            int index = this.MASK & buffer >> bitsLeft - this.SHIFT;
            result.append(this.DIGITS[index]);
        }
        return result.toString();
    }

    public byte[] decode(String encoded) {
        if (encoded.length() == 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        int encodedLength = encoded.length();
        int outLength = encodedLength * this.SHIFT / 8;
        byte[] result = new byte[outLength];
        int buffer = 0;
        int next = 0;
        int bitsLeft = 0;
        for (char c : encoded.toCharArray()) {
            buffer <<= this.SHIFT;
            buffer |= Arrays.binarySearch(this.DIGITS, c) & this.MASK;
            if ((bitsLeft += this.SHIFT) < 8) continue;
            result[next++] = (byte)(buffer >> bitsLeft - 8);
            bitsLeft -= 8;
        }
        assert (next == outLength && bitsLeft < this.SHIFT);
        return result;
    }
}

