/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConversionUtil {
    private static final Pattern ARRAY_MATCH = Pattern.compile("(\\w+)\\((\\d+)\\)");
    private static final Set<String> RESERVED_PARAMS = ImmutableSet.of((Object)"method", (Object)"id", (Object)"st");

    public static JSONObject fromRequest(HttpServletRequest request) throws JSONException {
        JSONObject root = new JSONObject();
        Map params = request.getParameterMap();
        root.put("method", (Object)((String[])params.get("method"))[0]);
        if (params.containsKey("id")) {
            root.put("id", (Object)((String[])params.get("id"))[0]);
        }
        JSONObject paramsRoot = new JSONObject();
        for (Map.Entry entry : params.entrySet()) {
            if (RESERVED_PARAMS.contains(((String)entry.getKey()).toLowerCase())) continue;
            String[] path = ((String)entry.getKey()).split("\\.");
            JSONObject holder = JsonConversionUtil.buildHolder(paramsRoot, path, 0);
            holder.put(path[path.length - 1], JsonConversionUtil.convertToJsonValue(((String[])entry.getValue())[0]));
        }
        if (paramsRoot.length() > 0) {
            root.put("params", (Object)paramsRoot);
        }
        return root;
    }

    public static Map<String, String> fromJson(JSONObject obj) throws JSONException {
        HashMap result = Maps.newHashMap();
        JsonConversionUtil.collect(obj, "", result);
        return result;
    }

    private static void collect(Object current, String prefix, Map<String, String> result) throws JSONException {
        if (current == null) {
            result.put(prefix, "null");
            return;
        }
        if (current instanceof JSONObject) {
            JSONObject json = (JSONObject)current;
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (json.isNull(key)) {
                    result.put(prefix + "." + key, "null");
                    continue;
                }
                JsonConversionUtil.collect(json.get(key), prefix + "." + key, result);
            }
        } else if (current instanceof JSONArray) {
            JSONArray jsonArr = (JSONArray)current;
            if (JsonConversionUtil.isAllLiterals(jsonArr)) {
                String jsonArrayString = jsonArr.toString();
                jsonArrayString = jsonArrayString.substring(1, jsonArrayString.length() - 1);
                if (jsonArr.length() == 1) {
                    jsonArrayString = "(" + jsonArrayString + ")";
                }
                result.put(prefix, jsonArrayString);
            } else {
                for (int i = 0; i < jsonArr.length(); ++i) {
                    if (jsonArr.isNull(i)) {
                        result.put(prefix + "(" + i + ")", "null");
                        continue;
                    }
                    JsonConversionUtil.collect(jsonArr.get(i), prefix + "(" + i + ")", result);
                }
            }
        } else {
            result.put(prefix, current.toString());
        }
    }

    public static boolean isAllLiterals(JSONArray jsonArr) throws JSONException {
        for (int i = 0; i < jsonArr.length(); ++i) {
            if (jsonArr.isNull(i) || !(jsonArr.get(i) instanceof JSONObject) && !(jsonArr.get(i) instanceof JSONArray)) continue;
            return false;
        }
        return true;
    }

    static JSONObject parametersToJsonObject(Map<String, String> params) throws JSONException {
        JSONObject root = new JSONObject();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String[] path = entry.getKey().split("\\.");
            JSONObject holder = JsonConversionUtil.buildHolder(root, path, 0);
            if (path.length > 1) {
                holder.put(path[path.length - 1], JsonConversionUtil.convertToJsonValue(entry.getValue()));
                continue;
            }
            holder.put(path[0], JsonConversionUtil.convertToJsonValue(entry.getValue()));
        }
        return root;
    }

    static JSONObject buildHolder(JSONObject root, String[] steps, int currentStep) throws JSONException {
        JSONObject newStep;
        if (currentStep > steps.length - 2) {
            return root;
        }
        Matcher matcher = ARRAY_MATCH.matcher(steps[currentStep]);
        if (matcher.matches()) {
            JSONArray newArrayStep;
            String fieldName = matcher.group(1);
            int index = Integer.parseInt(matcher.group(2));
            if (root.has(fieldName)) {
                newArrayStep = root.getJSONArray(fieldName);
            } else {
                newArrayStep = new JSONArray();
                root.put(fieldName, (Object)newArrayStep);
            }
            JSONObject newStep2 = new JSONObject();
            newArrayStep.put(index, (Object)newStep2);
            return JsonConversionUtil.buildHolder(newStep2, steps, ++currentStep);
        }
        if (root.has(steps[currentStep])) {
            newStep = root.getJSONObject(steps[currentStep]);
        } else {
            newStep = new JSONObject();
            root.put(steps[currentStep], (Object)newStep);
        }
        return JsonConversionUtil.buildHolder(newStep, steps, ++currentStep);
    }

    static Object convertToJsonValue(String value) throws JSONException {
        if (value == null) {
            return null;
        }
        if (value.startsWith("(") && value.endsWith(")")) {
            return new JSONArray("[" + value.substring(1, value.length() - 1) + "]");
        }
        try {
            JSONArray parsedArray = new JSONArray("[" + value + "]");
            if (parsedArray.length() == 1) {
                return parsedArray.get(0);
            }
            return parsedArray;
        }
        catch (JSONException je) {
            return value;
        }
    }
}

