/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.tools.jmx.Manager;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class GuiceServletContextListener
implements ServletContextListener {
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";
    public static final String MODULES_ATTRIBUTE = "guice-modules";
    private boolean jmxInitialized = false;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String moduleNames = context.getInitParameter(MODULES_ATTRIBUTE);
        LinkedList modules = Lists.newLinkedList();
        if (moduleNames != null) {
            for (String moduleName : moduleNames.split(":")) {
                try {
                    moduleName = moduleName.trim();
                    if (moduleName.length() <= 0) continue;
                    modules.add((Module)Class.forName(moduleName).newInstance());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules);
        context.setAttribute(INJECTOR_ATTRIBUTE, (Object)injector);
        try {
            if (!this.jmxInitialized) {
                Manager.manage((String)"ShindigGuiceContext", (Injector)injector);
                this.jmxInitialized = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }
}

