/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache.ehcache;

import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.management.ManagementService;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.ehcache.EhConfiguredCache;
import org.apache.shindig.common.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheCacheProvider
implements CacheProvider {
    private final Logger LOG = LoggerFactory.getLogger((String)EhCacheCacheProvider.class.getName());
    private final CacheManager cacheManager;
    private final Map<String, Cache<?, ?>> caches = new MapMaker().makeMap();

    @Inject
    public EhCacheCacheProvider(@Named(value="shindig.cache.ehcache.config") String configPath, @Named(value="shindig.cache.ehcache.jmx.enabled") boolean jmxEnabled, @Named(value="shindig.cache.ehcache.jmx.stats") boolean withCacheStats) throws IOException {
        this.cacheManager = new CacheManager(this.getConfiguration(configPath));
        this.create(jmxEnabled, withCacheStats);
    }

    protected Configuration getConfiguration(String configPath) throws IOException {
        InputStream configStream = ResourceLoader.open(configPath);
        return ConfigurationFactory.parseConfiguration((InputStream)configStream);
    }

    public void create(boolean jmxEnabled, boolean withCacheStats) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    EhCacheCacheProvider.this.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        if (jmxEnabled) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)mBeanServer, (boolean)true, (boolean)true, (boolean)true, (boolean)withCacheStats);
        }
    }

    public void shutdown() {
        this.cacheManager.shutdown();
    }

    @Override
    public <K, V> Cache<K, V> createCache(String name) {
        if (name == null) {
            this.LOG.info("Creating anonymous cache");
            return new EhConfiguredCache(name, this.cacheManager);
        }
        Cache<?, ?> cache = this.caches.get(name);
        if (cache == null) {
            this.LOG.info("Creating cache named " + name);
            cache = new EhConfiguredCache(name, this.cacheManager);
            this.caches.put(name, cache);
        }
        return cache;
    }
}

