/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class BasicSecurityToken
implements SecurityToken {
    private final String token;
    private final Map<String, String> tokenData;
    private BlobCrypter crypter = new BasicBlobCrypter(INSECURE_KEY);
    private final String activeUrl;
    private static final byte[] INSECURE_KEY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String OWNER_KEY = "o";
    private static final String APP_KEY = "a";
    private static final String VIEWER_KEY = "v";
    private static final String DOMAIN_KEY = "d";
    private static final String APPURL_KEY = "u";
    private static final String MODULE_KEY = "m";
    private static final String CONTAINER_KEY = "c";

    public String toSerialForm() {
        return this.token;
    }

    public BasicSecurityToken(String token, int maxAge, String activeUrl) throws BlobCrypterException {
        this.token = token;
        this.tokenData = this.crypter.unwrap(token, maxAge);
        this.activeUrl = activeUrl;
    }

    public BasicSecurityToken(String owner, String viewer, String app, String domain, String appUrl, String moduleId, String container, String activeUrl) throws BlobCrypterException {
        this.tokenData = Maps.newHashMapWithExpectedSize((int)5);
        this.putNullSafe(OWNER_KEY, owner);
        this.putNullSafe(VIEWER_KEY, viewer);
        this.putNullSafe(APP_KEY, app);
        this.putNullSafe(DOMAIN_KEY, domain);
        this.putNullSafe(APPURL_KEY, appUrl);
        this.putNullSafe(MODULE_KEY, moduleId);
        this.putNullSafe(CONTAINER_KEY, container);
        this.token = this.crypter.wrap(this.tokenData);
        this.activeUrl = activeUrl;
    }

    private void putNullSafe(String key, String value) {
        if (value != null) {
            this.tokenData.put(key, value);
        }
    }

    public String getAppId() {
        return this.tokenData.get(APP_KEY);
    }

    public String getDomain() {
        return this.tokenData.get(DOMAIN_KEY);
    }

    public String getContainer() {
        return this.tokenData.get(CONTAINER_KEY);
    }

    public String getOwnerId() {
        return this.tokenData.get(OWNER_KEY);
    }

    public String getViewerId() {
        return this.tokenData.get(VIEWER_KEY);
    }

    public String getAppUrl() {
        return this.tokenData.get(APPURL_KEY);
    }

    public String getModuleId() {
        return this.tokenData.get(MODULE_KEY);
    }

    public String getUpdatedToken() {
        return null;
    }

    public String getTrustedJson() {
        return null;
    }

    public boolean isAnonymous() {
        return false;
    }

    public String getActiveUrl() {
        if (this.activeUrl == null) {
            throw new UnsupportedOperationException("No active URL available");
        }
        return this.activeUrl;
    }
}

