/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge.serviceprovider;

import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.Token;
import com.atlassian.oauth.bridge.Consumers;
import com.atlassian.oauth.bridge.Tokens;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.util.Check;
import net.oauth.OAuthAccessor;

public final class ServiceProviderTokens {
    public static OAuthAccessor asOAuthAccessor(ServiceProviderToken token, ServiceProvider serviceProvider) {
        Check.notNull((Object)token, (Object)"token");
        Check.notNull((Object)serviceProvider, (Object)"serviceProvider");
        OAuthAccessor accessor = new OAuthAccessor(Consumers.asOAuthConsumer(token.getConsumer(), serviceProvider));
        ServiceProviderTokens.setTokenData(accessor, token);
        return accessor;
    }

    private static void setTokenData(OAuthAccessor accessor, ServiceProviderToken token) {
        Tokens.setCommonTokenData(accessor, (Token)token);
        if (token.isRequestToken()) {
            if (token.getAuthorization() == ServiceProviderToken.Authorization.AUTHORIZED) {
                accessor.setProperty("user", (Object)token.getUser());
                accessor.setProperty("authorized", (Object)true);
            } else if (token.getAuthorization() == ServiceProviderToken.Authorization.DENIED) {
                accessor.setProperty("user", (Object)token.getUser());
                accessor.setProperty("authorized", (Object)false);
            }
        } else {
            accessor.accessToken = token.getToken();
            accessor.setProperty("user", (Object)token.getUser());
            accessor.setProperty("authorized", (Object)true);
        }
        accessor.tokenSecret = token.getTokenSecret();
        accessor.setProperty("creationTime", (Object)token.getCreationTime());
    }
}

