/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge.consumer;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.Token;
import com.atlassian.oauth.bridge.Consumers;
import com.atlassian.oauth.bridge.Tokens;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.oauth.util.Check;
import java.security.PrivateKey;
import net.oauth.OAuthAccessor;

public final class ConsumerTokens {
    public static OAuthAccessor asOAuthAccessor(ConsumerToken token, ServiceProvider serviceProvider) {
        Check.notNull((Object)token, (Object)"token");
        Check.notNull((Object)serviceProvider, (Object)"serviceProvider");
        OAuthAccessor accessor = new OAuthAccessor(Consumers.asOAuthConsumer(token.getConsumer(), serviceProvider));
        Tokens.setCommonTokenData(accessor, (Token)token);
        return accessor;
    }

    public static OAuthAccessor asOAuthAccessor(ConsumerToken token, PrivateKey privateKey, ServiceProvider serviceProvider) {
        Check.notNull((Object)token, (Object)"token");
        Check.notNull((Object)serviceProvider, (Object)"serviceProvider");
        OAuthAccessor accessor = new OAuthAccessor(Consumers.asOAuthConsumer(token.getConsumer(), privateKey, serviceProvider));
        Tokens.setCommonTokenData(accessor, (Token)token);
        return accessor;
    }

    public static OAuthAccessor asOAuthAccessor(ConsumerToken token, String sharedSecret, ServiceProvider serviceProvider) {
        Check.notNull((Object)token, (Object)"token");
        Check.notNull((Object)serviceProvider, (Object)"serviceProvider");
        OAuthAccessor accessor = new OAuthAccessor(Consumers.asOAuthConsumer(token.getConsumer(), sharedSecret, serviceProvider));
        Tokens.setCommonTokenData(accessor, (Token)token);
        return accessor;
    }

    public static ConsumerToken asConsumerToken(OAuthAccessor accessor) {
        Check.notNull((Object)accessor, (Object)"accessor");
        Consumer consumer = Consumers.fromOAuthConsumer(accessor.consumer);
        if (accessor.accessToken != null) {
            return ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)ConsumerToken.newAccessToken((String)accessor.accessToken).tokenSecret(accessor.tokenSecret)).consumer(consumer)).build();
        }
        return ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)ConsumerToken.newRequestToken((String)accessor.requestToken).tokenSecret(accessor.tokenSecret)).consumer(consumer)).build();
    }
}

