/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge;

import com.atlassian.oauth.Token;
import java.util.Map;
import net.oauth.OAuthAccessor;

public final class Tokens {
    private Tokens() {
    }

    public static void setCommonTokenData(OAuthAccessor accessor, Token token) {
        if (token.isRequestToken()) {
            accessor.requestToken = token.getToken();
        } else {
            accessor.accessToken = token.getToken();
        }
        accessor.tokenSecret = token.getTokenSecret();
        for (Map.Entry property : token.getProperties().entrySet()) {
            accessor.setProperty((String)property.getKey(), property.getValue());
        }
    }

    public static final class AccessorProperty {
        public static final String USER = "user";
        public static final String AUTHORIZED = "authorized";
        public static final String VERIFIER = "verifier";
        public static final String CALLBACK = "callback";
        public static final String CREATION_TIME = "creationTime";
    }
}

