/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.bridge.ServiceProviders;
import com.atlassian.oauth.util.Check;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;

public final class Consumers {
    private Consumers() {
    }

    public static OAuthConsumer asOAuthConsumer(Consumer consumer, ServiceProvider serviceProvider) {
        return Consumers.asOAuthConsumer(consumer, (String)null, serviceProvider);
    }

    public static OAuthConsumer asOAuthConsumer(Consumer consumer, OAuthServiceProvider oauthServiceProvider) {
        return Consumers.asOAuthConsumer(consumer, (String)null, oauthServiceProvider);
    }

    public static OAuthConsumer asOAuthConsumer(Consumer consumer, PrivateKey privateKey, ServiceProvider serviceProvider) {
        OAuthConsumer oauthConsumer = Consumers.asOAuthConsumer(consumer, serviceProvider);
        oauthConsumer.setProperty("RSA-SHA1.PrivateKey", (Object)privateKey);
        return oauthConsumer;
    }

    public static OAuthConsumer asOAuthConsumer(Consumer consumer, String sharedSecret, ServiceProvider serviceProvider) {
        Check.notNull((Object)serviceProvider, (Object)"serviceProvider");
        return Consumers.asOAuthConsumer(consumer, sharedSecret, ServiceProviders.asOAuthServiceProvider(serviceProvider));
    }

    public static OAuthConsumer asOAuthConsumer(Consumer consumer, String sharedSecret, OAuthServiceProvider oauthServiceProvider) {
        Check.notNull((Object)consumer, (Object)"consumer");
        Check.notNull((Object)oauthServiceProvider, (Object)"oauthServiceProvider");
        String callback = consumer.getCallback() != null ? consumer.getCallback().toString() : null;
        OAuthConsumer oauthConsumer = new OAuthConsumer(callback, consumer.getKey(), sharedSecret, oauthServiceProvider);
        oauthConsumer.setProperty("name", (Object)consumer.getName());
        oauthConsumer.setProperty("description", (Object)consumer.getDescription());
        if (consumer.getSignatureMethod() == Consumer.SignatureMethod.RSA_SHA1) {
            oauthConsumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            oauthConsumer.setProperty("RSA-SHA1.PublicKey", (Object)consumer.getPublicKey());
        } else {
            oauthConsumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        }
        return oauthConsumer;
    }

    public static Consumer fromOAuthConsumer(OAuthConsumer consumer) {
        Check.notNull((Object)consumer, (Object)"consumer");
        String name = (String)consumer.getProperty("name");
        URI callback = consumer.callbackURL != null ? URI.create(consumer.callbackURL) : null;
        String description = (String)consumer.getProperty("description");
        Consumer.InstanceBuilder builder = Consumer.key((String)consumer.consumerKey).name(name).description(description).callback(callback);
        if (consumer.getProperty("oauth_signature_method").equals("HMAC-SHA1")) {
            builder.signatureMethod(Consumer.SignatureMethod.HMAC_SHA1);
        } else {
            PublicKey publicKey = (PublicKey)consumer.getProperty("RSA-SHA1.PublicKey");
            builder.publicKey(publicKey);
        }
        return builder.build();
    }

    static final class ConsumerProperty {
        static final String NAME = "name";
        static final String DESCRIPTION = "description";

        ConsumerProperty() {
        }
    }
}

