/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.DelegatingInputStream;
import org.codehaus.httpcache4j.payload.Payload;

public class InputStreamPayload
implements Payload {
    private final InputStream stream;
    private final MIMEType mimeType;
    private boolean available = true;

    public InputStreamPayload(InputStream stream, MIMEType mimeType) {
        Validate.notNull((Object)stream, (String)"Inputstream may not be null");
        this.mimeType = mimeType != null ? mimeType : MIMEType.APPLICATION_OCTET_STREAM;
        this.stream = new WrappedInputStream(stream);
    }

    public MIMEType getMimeType() {
        return this.mimeType;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public InputStream getInputStream() {
        if (this.available) {
            return this.stream;
        }
        return ClosedInputStream.CLOSED_INPUT_STREAM;
    }

    private class WrappedInputStream
    extends DelegatingInputStream {
        public WrappedInputStream(InputStream delegate) {
            super(delegate);
        }

        public int read() throws IOException {
            if (InputStreamPayload.this.isAvailable()) {
                InputStreamPayload.this.available = false;
            }
            return super.read();
        }

        public int read(byte[] b) throws IOException {
            if (InputStreamPayload.this.isAvailable()) {
                InputStreamPayload.this.available = false;
            }
            return super.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (InputStreamPayload.this.isAvailable()) {
                InputStreamPayload.this.available = false;
            }
            return super.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            if (InputStreamPayload.this.isAvailable()) {
                InputStreamPayload.this.available = false;
            }
            return super.skip(n);
        }
    }
}

