/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HTTPVersion {
    HTTP_1_1(1, 1),
    HTTP_1_0(1, 0);

    private final int major;
    private final int minor;

    private HTTPVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public static HTTPVersion get(String version) {
        if (version != null && version.length() == 3) {
            int major = NumberUtils.toInt((String)version.substring(0, 1));
            int minor = NumberUtils.toInt((String)version.substring(2));
            if (HTTP_1_1.getMajor() == major && HTTP_1_1.getMinor() == minor) {
                return HTTP_1_1;
            }
            if (HTTP_1_0.getMajor() == major && HTTP_1_0.getMinor() == minor) {
                return HTTP_1_0;
            }
        }
        return HTTP_1_1;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

